/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import eu.solven.cleanthat.engine.java.refactorer.AstRefactorerInstance;
import eu.solven.cleanthat.engine.java.refactorer.JavaRefactorerProperties;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IReApplyUntilNoop;
import eu.solven.cleanthat.engine.java.refactorer.meta.IWalkingMutator;
import eu.solven.cleanthat.engine.java.refactorer.mutators.composite.AllIncludingDraftCompositeMutators;
import eu.solven.cleanthat.engine.java.refactorer.mutators.composite.AllIncludingDraftSingleMutators;
import eu.solven.cleanthat.engine.java.refactorer.mutators.composite.CompositeMutator;
import eu.solven.cleanthat.formatter.ILintFixerWithId;
import eu.solven.cleanthat.formatter.ILintFixerWithPath;
import eu.solven.cleanthat.formatter.PathAndContent;
import eu.solven.cleanthat.language.IEngineProperties;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAstRefactorer<AST, P, R, M extends IWalkingMutator<AST, R>>
implements ILintFixerWithId,
ILintFixerWithPath {
    private static final Logger LOGGER = LoggerFactory.getLogger(AAstRefactorer.class);
    private static final int MAX_REAPPLY = 10;
    private final List<M> mutators;

    public AAstRefactorer(List<M> mutators) {
        this.mutators = ImmutableList.copyOf(mutators);
        this.mutators.forEach(ct -> LOGGER.debug("Using transformer: {}", ct.getIds()));
    }

    public Set<String> getMutatorIds() {
        return this.mutators.stream().flatMap(m -> m.getIds().stream()).sorted().collect(Collectors.toSet());
    }

    protected Iterable<M> getRawMutators() {
        return this.mutators;
    }

    public static <AST, P> Optional<AST> parse(AAstRefactorer<AST, P, ?, ?> refactorer, String sourceCode) {
        P parser = refactorer.makeAstParser();
        return refactorer.parseSourceCode(parser, sourceCode);
    }

    protected abstract P makeAstParser();

    protected abstract Optional<AST> parseSourceCode(P var1, String var2);

    public String doFormat(PathAndContent pathAndContent) throws IOException {
        return this.doFormat(pathAndContent.getContent());
    }

    public String doFormat(String content) throws IOException {
        return this.doFormat(new PathAndContent(NO_PATH, content));
    }

    protected String applyTransformers(PathAndContent pathAndContent) {
        AtomicReference<String> refCleanCode = new AtomicReference<String>(pathAndContent.getContent());
        AtomicReference refCompilationUnit = new AtomicReference();
        P parser = this.makeAstParser();
        AtomicBoolean firstMutator = new AtomicBoolean(true);
        AtomicBoolean inputIsBroken = new AtomicBoolean(false);
        Path path = pathAndContent.getPath();
        this.getRawMutators().forEach(ct -> {
            int maxNbApply = ct instanceof IReApplyUntilNoop ? 10 : 1;
            AstRefactorerInstance instance = new AstRefactorerInstance(this, parser, ct, refCompilationUnit, firstMutator, inputIsBroken);
            for (int i = 0; i < maxNbApply; ++i) {
                boolean appliedWithChange = instance.applyOneMutator(refCleanCode, refCompilationUnit, firstMutator, inputIsBroken, path);
                if (!appliedWithChange) {
                    LOGGER.debug("No more change after iteration={}", (Object)i);
                    break;
                }
                LOGGER.debug("Effective change after iteration={}", (Object)i);
            }
        });
        return refCleanCode.get();
    }

    protected abstract boolean isValidResultString(P var1, String var2);

    public static List<IMutator> filterRules(IEngineProperties engineProperties, JavaRefactorerProperties properties) {
        String languageLevel = engineProperties.getEngineVersion();
        if (Strings.isNullOrEmpty((String)languageLevel)) {
            languageLevel = "99.999";
        }
        JavaVersion engineVersion = JavaVersion.parse((String)languageLevel);
        List<String> includedRules = properties.getMutators();
        List<String> excludedRules = properties.getExcludedMutators();
        boolean includeDraft = properties.isIncludeDraft();
        return AAstRefactorer.filterRules(engineVersion, includedRules, excludedRules, includeDraft);
    }

    public static List<IMutator> filterRules(JavaVersion sourceCodeVersion, List<String> includedRules, List<String> excludedRules, boolean includeDraft) {
        List allSingleMutators = new AllIncludingDraftSingleMutators(JavaVersion.parse((String)"99.999")).getUnderlyings();
        List allCompositeMutators = new AllIncludingDraftCompositeMutators(JavaVersion.parse((String)"99.999")).getUnderlyings();
        Set allSingleIds = allSingleMutators.stream().flatMap(m -> m.getIds().stream()).collect(Collectors.toCollection(TreeSet::new));
        Set allCompositeIds = allCompositeMutators.stream().flatMap(m -> m.getIds().stream()).collect(Collectors.toCollection(TreeSet::new));
        List compatibleSingleMutators = new AllIncludingDraftSingleMutators(sourceCodeVersion).getUnderlyings();
        List compatibleCompositeMutators = new AllIncludingDraftCompositeMutators(sourceCodeVersion).getUnderlyings();
        Set compatibleSingleIds = compatibleSingleMutators.stream().flatMap(m -> m.getIds().stream()).collect(Collectors.toCollection(TreeSet::new));
        Set compatibleCompositeIds = compatibleCompositeMutators.stream().flatMap(m -> m.getIds().stream()).collect(Collectors.toCollection(TreeSet::new));
        List<IMutator> mutatorsMayComposite = includedRules.stream().flatMap(includedRule -> {
            if ("*".equals(includedRule)) {
                LOGGER.warn("'{}' is a legacy keyword, and should be replaced by {} and {}", new Object[]{"*", AllIncludingDraftCompositeMutators.class.getSimpleName(), AllIncludingDraftSingleMutators.class.getSimpleName()});
                return compatibleSingleMutators.stream();
            }
            List matchingMutators = Stream.concat(compatibleSingleMutators.stream(), compatibleCompositeMutators.stream()).filter(someMutator -> AAstRefactorer.isAcceptedMutator(includedRule, someMutator)).collect(Collectors.toList());
            if (!matchingMutators.isEmpty()) {
                return matchingMutators.stream();
            }
            Optional<IMutator> optFromClassName = AAstRefactorer.loadMutatorFromClass(sourceCodeVersion, includedRule);
            if (optFromClassName.isPresent()) {
                return optFromClassName.stream();
            }
            if (allSingleIds.contains(includedRule) || allCompositeIds.contains(includedRule)) {
                LOGGER.warn("includedMutator={} matches some mutators, but not compatible with sourceCodeVersion={}", includedRule, (Object)sourceCodeVersion);
            } else {
                LOGGER.warn("includedMutator={} did not match any compatible mutator (sourceCodeVersion={}) singleIds={} compositeIds={}", new Object[]{includedRule, sourceCodeVersion, compatibleSingleIds, compatibleCompositeIds});
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        List<IMutator> mutatorsNotComposite = AAstRefactorer.unrollCompositeMutators(mutatorsMayComposite);
        return mutatorsNotComposite.stream().filter(arg_0 -> AAstRefactorer.lambda$filterRules$9(excludedRules, arg_0)).filter(ct -> {
            if (includeDraft) {
                return true;
            }
            if (mutatorsMayComposite.contains(ct)) {
                LOGGER.debug("Draft are not included by default but {} was listed explicitely", ct.getIds());
                return true;
            }
            return !ct.isDraft();
        }).collect(Collectors.toList());
    }

    private static boolean isAcceptedMutator(String includedRule, IMutator someMutator) {
        if (someMutator.getIds().contains(includedRule)) {
            return true;
        }
        return someMutator.getClass().getName().equals(includedRule);
    }

    private static Optional<IMutator> loadMutatorFromClass(JavaVersion sourceCodeVersion, String includedRule) {
        try {
            IMutator mutator;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> mutatorClass = Class.forName(includedRule, false, classLoader);
            if (CompositeMutator.class.isAssignableFrom(mutatorClass)) {
                Constructor<?> ctor = mutatorClass.getConstructor(JavaVersion.class);
                mutator = (IMutator)ctor.newInstance(sourceCodeVersion);
            } else {
                Constructor<?> ctor = mutatorClass.getConstructor(new Class[0]);
                mutator = (IMutator)ctor.newInstance(new Object[0]);
            }
            return Optional.of(mutator);
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("includedMutator {} is not present classname", (Object)includedRule, (Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Unexpected constructor for includedMutator=" + includedRule, e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Invalid class for includedMutator=" + includedRule, e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException("Issue instanciating includedMutator=" + includedRule, e);
        }
        return Optional.empty();
    }

    private static List<IMutator> unrollCompositeMutators(List<IMutator> mutatorsMayComposite) {
        List<IMutator> mutatorsNotComposite = mutatorsMayComposite;
        while (mutatorsNotComposite.stream().anyMatch(CompositeMutator.class::isInstance)) {
            mutatorsNotComposite = mutatorsNotComposite.stream().flatMap(m -> {
                if (m instanceof CompositeMutator) {
                    return ((CompositeMutator)m).getUnderlyings().stream();
                }
                return Stream.of(m);
            }).collect(Collectors.toList());
        }
        return mutatorsNotComposite;
    }

    protected abstract String toString(R var1);

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$filterRules$9(List excludedRules, IMutator mutator) {
        if (excludedRules.contains(mutator.getClass().getName())) ** GOTO lbl-1000
        if (excludedRules.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(mutator.getIds()))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = isExcluded = false;
        }
        if (isExcluded) {
            AAstRefactorer.LOGGER.debug("We exclude {}->'{}'", (Object)mutator.getClass().getName(), mutator.getIds());
        } else {
            AAstRefactorer.LOGGER.debug("We include {}->'{}'", (Object)mutator.getClass().getName(), mutator.getIds());
        }
        return isExcluded == false;
    }
}

