/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

public class UseUnderscoresInNumericLiterals
extends AJavaparserNodeMutator {
    private static final int BLOCK_SIZE = 3;

    public boolean isDraft() {
        return false;
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Primitive");
    }

    public String minimalJavaVersion() {
        return "1.7";
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_codestyle.html#useunderscoresinnumericliterals";
    }

    public Optional<String> getPmdId() {
        return Optional.of("UseUnderscoresInNumericLiterals");
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2148");
    }

    protected int getAcceptableDecimalLength() {
        return 4;
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> node) {
        Optional<Object> optNewValue;
        String noUnderscore;
        if (!(node.getNode() instanceof LiteralStringValueExpr)) {
            return false;
        }
        LiteralStringValueExpr literalStringExpr = (LiteralStringValueExpr)node.getNode();
        String asString = literalStringExpr.getValue();
        if (literalStringExpr instanceof IntegerLiteralExpr || literalStringExpr instanceof LongLiteralExpr) {
            noUnderscore = asString.replaceAll("_", "");
            if (noUnderscore.matches("\\d+")) {
                int nbDigits = noUnderscore.length();
                StringBuilder sb = new StringBuilder(nbDigits + nbDigits / 3);
                this.appendWithUnderscores(noUnderscore, sb);
                optNewValue = Optional.of(sb.toString());
            } else {
                optNewValue = Optional.empty();
            }
        } else if (literalStringExpr instanceof DoubleLiteralExpr) {
            noUnderscore = asString.replaceAll("_", "");
            if (noUnderscore.matches("\\d+(\\.\\d+)?([dDfF])?")) {
                StringBuilder sb;
                char lastChar = noUnderscore.charAt(noUnderscore.length() - 1);
                OptionalInt optTrailingChar = lastChar == 'f' || lastChar == 'F' || lastChar == 'd' || lastChar == 'D' ? OptionalInt.of(lastChar) : OptionalInt.empty();
                int lastIndex = optTrailingChar.isPresent() ? noUnderscore.length() - 1 : noUnderscore.length();
                int indexOfDot = noUnderscore.indexOf(46);
                if (indexOfDot <= 0) {
                    int nbDigits = noUnderscore.length();
                    sb = new StringBuilder(nbDigits + nbDigits / 3);
                    this.appendWithUnderscores(noUnderscore.substring(0, lastIndex), sb);
                } else {
                    int totalNbDigits = noUnderscore.length() - 1;
                    sb = new StringBuilder(totalNbDigits + 1 + totalNbDigits / 3);
                    String beforeDot = noUnderscore.substring(0, indexOfDot);
                    this.appendWithUnderscores(beforeDot, sb);
                    sb.append('.');
                    String afterDot = noUnderscore.substring(indexOfDot + 1, lastIndex);
                    this.appendWithUnderscores(afterDot, sb, true);
                }
                if (optTrailingChar.isPresent()) {
                    sb.append((char)optTrailingChar.getAsInt());
                }
                optNewValue = Optional.of(sb.toString());
            } else {
                optNewValue = Optional.empty();
            }
        } else {
            optNewValue = Optional.empty();
        }
        if (optNewValue.isPresent()) {
            String newValue = (String)optNewValue.get();
            if (newValue.equals(asString)) {
                return false;
            }
            literalStringExpr.setValue(newValue);
            return true;
        }
        return false;
    }

    private void appendWithUnderscores(String noUnderscore, StringBuilder sb) {
        this.appendWithUnderscores(noUnderscore, sb, false);
    }

    private void appendWithUnderscores(String noUnderscore, StringBuilder sb, boolean reverseForDecimals) {
        int nextBlockSize;
        if (noUnderscore.length() <= this.getAcceptableDecimalLength()) {
            sb.append(noUnderscore);
            return;
        }
        assert (noUnderscore.matches("\\d+"));
        int nbDigits = noUnderscore.length();
        int position = 0;
        for (int nbDigitsLeft = nbDigits; nbDigitsLeft > 0; nbDigitsLeft -= nextBlockSize) {
            if (position != 0) {
                sb.append('_');
            }
            nextBlockSize = reverseForDecimals ? Math.min(nbDigitsLeft, 3) : (nbDigitsLeft - 1) % 3 + 1;
            int nextPosition = position + nextBlockSize;
            String subString = noUnderscore.substring(position, nextPosition);
            sb.append(subString);
            position = nextPosition;
        }
    }
}

