/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyBeforeMe;
import eu.solven.cleanthat.engine.java.refactorer.mutators.AUseXIsEmpty;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LiteralsFirstInComparisons;
import java.util.Optional;
import java.util.Set;

@ApplyBeforeMe(value={LiteralsFirstInComparisons.class})
public class UseStringIsEmpty
extends AUseXIsEmpty {
    public boolean isDraft() {
        return false;
    }

    public String minimalJavaVersion() {
        return "1.6";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"String");
    }

    @Override
    protected String getSizeMethod() {
        return "length";
    }

    @Override
    protected Set<Class<?>> getCompatibleTypes() {
        return Set.of(String.class);
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        boolean replaced = super.processExpression(expr);
        if (replaced) {
            return true;
        }
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr asMethodCall = expr.getNode().asMethodCallExpr();
        if (!"equals".equals(asMethodCall.getNameAsString()) && !"equalsIgnoreCase".equals(asMethodCall.getNameAsString())) {
            return false;
        }
        if (asMethodCall.getArguments().size() != 1 || !asMethodCall.getArgument(0).isLiteralStringValueExpr() || !"".equals(asMethodCall.getArgument(0).asLiteralStringValueExpr().getValue())) {
            return false;
        }
        Optional optScope = asMethodCall.getScope();
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(optScope), String.class)) {
            return false;
        }
        return this.tryReplace(expr, (Node)new MethodCallExpr((Expression)optScope.get(), "isEmpty"));
    }
}

