/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;

public class UseIndexOfChar
extends AJavaparserNodeMutator {
    public String minimalJavaVersion() {
        return "1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"String");
    }

    public boolean isDraft() {
        return false;
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_performance.html#useindexofchar";
    }

    public Optional<String> getPmdId() {
        return Optional.of("UseIndexOfChar");
    }

    public String sonarUrl() {
        return "https://rules.sonarsource.com/java/RSPEC-1155";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-1155");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/use-is-empty-on-collections.html";
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> node) {
        if (!(node.getNode() instanceof StringLiteralExpr)) {
            return false;
        }
        StringLiteralExpr stringLiteralExpr = (StringLiteralExpr)node.getNode();
        if (stringLiteralExpr.getParentNode().isEmpty()) {
            return false;
        }
        Node parentNode = (Node)stringLiteralExpr.getParentNode().get();
        if (!(parentNode instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr parentMethodCall = (MethodCallExpr)parentNode;
        String parentMethodAsString = parentMethodCall.getNameAsString();
        boolean isIndexOf = "indexOf".equals(parentMethodAsString);
        boolean isLastIndexOf = "lastIndexOf".equals(parentMethodAsString);
        if (!isIndexOf && !isLastIndexOf) {
            return false;
        }
        Optional optScope = parentMethodCall.getScope();
        if (!MethodCallExprHelpers.scopeHasRequiredType(node.editNode(optScope), String.class)) {
            return false;
        }
        String stringLiteralExprValue = stringLiteralExpr.getValue();
        if (stringLiteralExprValue.isEmpty()) {
            if (isIndexOf) {
                return this.tryReplace(parentNode, (Node)new IntegerLiteralExpr("0"));
            }
            assert (isLastIndexOf);
            MethodCallExpr lengthMethodCall = new MethodCallExpr((Expression)optScope.get(), "length");
            return this.tryReplace(parentNode, (Node)lengthMethodCall);
        }
        if (stringLiteralExprValue.length() != 1) {
            return false;
        }
        return this.tryReplace(node, (Node)new CharLiteralExpr(stringLiteralExprValue.charAt(0)));
    }
}

