/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;

public class ThreadRunToThreadStart
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "1";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-1217");
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Thread");
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCallExpr = expr.getNode().asMethodCallExpr();
        if (!"run".equals(methodCallExpr.getNameAsString())) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(methodCallExpr.getScope()), Thread.class)) {
            return false;
        }
        return this.tryReplace((Node)methodCallExpr, (Node)new MethodCallExpr((Expression)methodCallExpr.getScope().get(), "start", methodCallExpr.getArguments()));
    }
}

