/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.meta.IReApplyUntilNoop;
import eu.solven.cleanthat.engine.java.refactorer.meta.RepeatOnSuccess;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaIsMethodReference;
import eu.solven.cleanthat.engine.java.refactorer.mutators.StreamMutatorHelpers;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

@ApplyAfterMe(value={LambdaIsMethodReference.class})
@RepeatOnSuccess
public class StreamFlatMapStreamToFlatMap
extends AJavaparserExprMutator
implements IReApplyUntilNoop {
    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Stream");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("FlatMapInsteadOfNestedLoops");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/flat-map-instead-of-nested-loops.html";
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        Optional<MethodCallExpr> optFlatMapExpr = MethodCallExprHelpers.match(expr, Stream.class, "flatMap", Expression::isLambdaExpr);
        if (optFlatMapExpr.isEmpty()) {
            return false;
        }
        MethodCallExpr flatMapExpr = optFlatMapExpr.get();
        Optional optPreviousScope = flatMapExpr.getParentNode();
        Optional<MethodCallExpr> optFlatMapNextMethod = optPreviousScope.flatMap(n -> {
            if (n instanceof MethodCallExpr) {
                return Optional.of((MethodCallExpr)n);
            }
            return Optional.empty();
        });
        if (optFlatMapNextMethod.isEmpty()) {
            return false;
        }
        LambdaExpr forEachLambdaExpr = optFlatMapExpr.get().getArgument(0).asLambdaExpr();
        Optional<MethodCallExpr> optFlatMapInnerMethodCall = StreamMutatorHelpers.findSingleMethodCallExpr(forEachLambdaExpr.getBody());
        if (optFlatMapInnerMethodCall.isEmpty()) {
            return false;
        }
        MethodCallExpr flatMapInnerMethodCall = optFlatMapInnerMethodCall.get();
        Optional<MethodCallExpr> optInnerToStream = this.searchInnerToStream(flatMapInnerMethodCall);
        if (optInnerToStream.isEmpty()) {
            return false;
        }
        MethodCallExpr innerToStream = optInnerToStream.get();
        if (!"stream".equals(innerToStream.getNameAsString())) {
            return false;
        }
        if (innerToStream.getParentNode().isEmpty() || !(innerToStream.getParentNode().get() instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr overStreamCall = (MethodCallExpr)innerToStream.getParentNode().get();
        return this.doReplace(flatMapExpr, flatMapInnerMethodCall, innerToStream, overStreamCall, optFlatMapNextMethod);
    }

    private boolean doReplace(MethodCallExpr flatMapExpr, MethodCallExpr flatMapInnerMethodCall, MethodCallExpr innerToStream, MethodCallExpr overStreamCall, Optional<MethodCallExpr> optFlatMapNextMethod) {
        boolean replaced = this.tryReplace((Node)flatMapInnerMethodCall, (Node)innerToStream);
        if (!replaced) {
            return false;
        }
        optFlatMapNextMethod.ifPresent(next -> next.setScope((Expression)flatMapInnerMethodCall));
        overStreamCall.setScope((Expression)flatMapExpr);
        return true;
    }

    private Optional<MethodCallExpr> searchInnerToStream(MethodCallExpr flatMapInnerMethodCall) {
        MethodCallExpr innerToStream = flatMapInnerMethodCall;
        while (innerToStream.getScope().isPresent() && innerToStream.getScope().get() instanceof MethodCallExpr) {
            innerToStream = (MethodCallExpr)innerToStream.getScope().get();
        }
        if (innerToStream.equals((Object)flatMapInnerMethodCall)) {
            return Optional.empty();
        }
        return Optional.of(innerToStream);
    }
}

