/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import java.util.Optional;
import java.util.Set;

public class RemoveExplicitCallToSuper
extends AJavaparserNodeMutator {
    public String minimalJavaVersion() {
        return "1.1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"ExplicitToImplicit");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("RemoveExplicitCallToSuper");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/remove-explicit-call-to-super.html";
    }

    public boolean isDraft() {
        return false;
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> node) {
        if (!(node.getNode() instanceof ConstructorDeclaration)) {
            return false;
        }
        ConstructorDeclaration constructor = (ConstructorDeclaration)node.getNode();
        BlockStmt body = constructor.getBody();
        if (body.getStatements().isEmpty()) {
            return false;
        }
        Statement firstStatement = body.getStatement(0);
        if (!firstStatement.isExplicitConstructorInvocationStmt()) {
            return false;
        }
        if (firstStatement.asExplicitConstructorInvocationStmt().getArguments().isEmpty()) {
            return this.tryRemove((Node)firstStatement);
        }
        return false;
    }
}

