/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;

public class OptionalNotEmpty
extends AJavaparserExprMutator {
    private static final String ID_NOTEMPTY = "OptionalNotEmpty";
    private static final String ID_ISPRESENT = "OptionalIsPresent";
    private static final String METHOD_IS_PRESENT = "isPresent";
    private static final String METHOD_IS_EMPTY = "isEmpty";

    public String minimalJavaVersion() {
        return "11";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Redundancy", (Object)"Optional");
    }

    public boolean isDraft() {
        return false;
    }

    public Set<String> getIds() {
        return ImmutableSet.of((Object)ID_NOTEMPTY, (Object)ID_ISPRESENT);
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCall = expr.getNode().asMethodCallExpr();
        String methodCallIdentifier = methodCall.getName().getIdentifier();
        if (!METHOD_IS_EMPTY.equals(methodCallIdentifier) && !METHOD_IS_PRESENT.equals(methodCallIdentifier)) {
            return false;
        }
        Optional optParent = methodCall.getParentNode();
        if (methodCall.getScope().isEmpty() || optParent.isEmpty() || !(optParent.get() instanceof UnaryExpr)) {
            return false;
        }
        UnaryExpr unaryExpr = (UnaryExpr)optParent.get();
        if (!"LOGICAL_COMPLEMENT".equals(unaryExpr.getOperator().name())) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(optScope), Optional.class)) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        String newMethod = METHOD_IS_EMPTY.equals(methodCallIdentifier) ? METHOD_IS_PRESENT : METHOD_IS_EMPTY;
        boolean localTransformed = false;
        MethodCallExpr replacement = new MethodCallExpr(scope, newMethod);
        if (this.tryReplace((Node)unaryExpr, (Node)replacement)) {
            localTransformed = true;
        }
        return localTransformed;
    }
}

