/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ObjectEqualsForPrimitives
extends AJavaparserExprMutator {
    private static final List<Class<?>> PRIMITIVE_CLASSES = Arrays.asList(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);

    public String minimalJavaVersion() {
        return "1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Primitive");
    }

    public Optional<String> getErrorProneId() {
        return Optional.of("ObjectEqualsForPrimitives");
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCall = expr.getNode().asMethodCallExpr();
        String methodCallIdentifier = methodCall.getName().getIdentifier();
        if (!"equals".equals(methodCallIdentifier)) {
            return false;
        }
        if (methodCall.getArguments().size() != 2) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (optScope.isEmpty() || !((Expression)optScope.get()).isNameExpr() || !"Objects".equals(((Expression)optScope.get()).asNameExpr().getNameAsString())) {
            return false;
        }
        Expression left = methodCall.getArgument(0);
        Expression right = methodCall.getArgument(1);
        if (PRIMITIVE_CLASSES.stream().anyMatch(c -> MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(left), c) && MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(right), c))) {
            BinaryExpr replacement = new BinaryExpr(left, right, BinaryExpr.Operator.EQUALS);
            return this.tryReplace(expr, (Node)replacement);
        }
        return false;
    }
}

