/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VarType;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ResolvedTypeHelpers;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalVariableTypeInference
extends AJavaparserNodeMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalVariableTypeInference.class);

    public String minimalJavaVersion() {
        return "10";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"ExplicitToImplicit");
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-6212");
    }

    public Set<String> getSeeUrls() {
        return Set.of("https://openjdk.org/jeps/286");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("LocalVariableTypeInference");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/local-variable-type-inference.html";
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> node) {
        if (!(node.getNode() instanceof VariableDeclarationExpr)) {
            return false;
        }
        VariableDeclarationExpr variableDeclarationExpr = (VariableDeclarationExpr)node.getNode();
        if (variableDeclarationExpr.getVariables().size() >= 2) {
            return false;
        }
        VariableDeclarator singleVariableDeclaration = variableDeclarationExpr.getVariable(0);
        Type type = singleVariableDeclaration.getType();
        if (type.isVarType()) {
            return false;
        }
        Expression initializer = singleVariableDeclaration.getInitializer().orElse(null);
        if (!this.isReplaceableAssignement(node, type, initializer)) {
            return false;
        }
        VariableDeclarator newVariableDeclarator = new VariableDeclarator((Type)new VarType(), singleVariableDeclaration.getName(), initializer);
        VariableDeclarationExpr newVariableDeclarationExpr = new VariableDeclarationExpr(newVariableDeclarator);
        newVariableDeclarationExpr.setModifiers(variableDeclarationExpr.getModifiers());
        newVariableDeclarationExpr.setAnnotations(variableDeclarationExpr.getAnnotations());
        return this.tryReplace((Node)variableDeclarationExpr, (Node)newVariableDeclarationExpr);
    }

    private boolean isReplaceableAssignement(NodeAndSymbolSolver<?> context, Type variableType, Expression initializer) {
        if (initializer == null) {
            return false;
        }
        if (initializer.isLambdaExpr()) {
            return false;
        }
        Optional<ResolvedType> optInitializerType = MethodCallExprHelpers.optResolvedType(context.editNode(initializer));
        if (optInitializerType.isEmpty()) {
            return false;
        }
        Optional<ResolvedType> optVariableType = ResolvedTypeHelpers.optResolvedType(variableType);
        if (optVariableType.isEmpty()) {
            return false;
        }
        ResolvedType initializerType = optInitializerType.get();
        ResolvedType resolvedVariableType = optVariableType.get();
        if (!initializerType.describe().equals(resolvedVariableType.describe())) {
            return false;
        }
        if (initializerType.isReferenceType() && resolvedVariableType.isReferenceType()) {
            List initializerTypeParametersMap;
            List variableTypeParametersMap;
            try {
                ResolvedReferenceType variableReferenceType = resolvedVariableType.asReferenceType();
                variableTypeParametersMap = variableReferenceType.getTypeParametersMap();
            }
            catch (UnsolvedSymbolException e) {
                LOGGER.debug("Issue solving a Symbol type: {}", (Throwable)e);
                return false;
            }
            try {
                ResolvedReferenceType initializerReferenceType = initializerType.asReferenceType();
                initializerTypeParametersMap = initializerReferenceType.getTypeParametersMap();
            }
            catch (UnsolvedSymbolException e) {
                LOGGER.debug("Issue solving a Symbol type: {}", (Throwable)e);
                return false;
            }
            return initializerTypeParametersMap.isEmpty() && variableTypeParametersMap.isEmpty();
        }
        return true;
    }
}

