/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.OptionalOrRejection;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ResolvedTypeHelpers;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArithmeticOverFloats
extends AJavaparserExprMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArithmeticOverFloats.class);
    private static final Set<BinaryExpr.Operator> MATH_FLOAT_OPERATORS = Set.of(BinaryExpr.Operator.PLUS, BinaryExpr.Operator.MINUS, BinaryExpr.Operator.MULTIPLY, BinaryExpr.Operator.DIVIDE);

    public String minimalJavaVersion() {
        return "1";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2164");
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Primitive");
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isBinaryExpr()) {
            return false;
        }
        BinaryExpr binaryExpr = expr.getNode().asBinaryExpr();
        if (!MATH_FLOAT_OPERATORS.contains(binaryExpr.getOperator())) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(binaryExpr.getLeft()), Float.TYPE)) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(binaryExpr.getRight()), Float.TYPE)) {
            return false;
        }
        OptionalOrRejection<Expression> needCastToDouble = this.optNeedCastToDouble(binaryExpr);
        if (needCastToDouble.isRejected()) {
            return false;
        }
        binaryExpr.setLeft((Expression)new CastExpr((Type)new ClassOrInterfaceType("double"), binaryExpr.getLeft()));
        needCastToDouble.ifPresent(e -> {
            Expression casted = e.clone();
            if (!casted.isEnclosedExpr()) {
                casted = new EnclosedExpr(casted);
            }
            this.tryReplace((Node)e, (Node)new CastExpr((Type)new ClassOrInterfaceType("float"), casted));
        });
        return true;
    }

    private OptionalOrRejection<Expression> optNeedCastToDouble(BinaryExpr binaryExpr) {
        Optional optParentNode;
        Optional<Object> needCastToDouble = Optional.empty();
        BinaryExpr child = binaryExpr;
        while ((optParentNode = child.getParentNode()).isPresent()) {
            Node parent = (Node)optParentNode.get();
            if (parent instanceof BinaryExpr) {
                BinaryExpr parentBinaryExpr = (BinaryExpr)parent;
                if (!MATH_FLOAT_OPERATORS.contains(parentBinaryExpr.getOperator())) {
                    return OptionalOrRejection.reject();
                }
            } else {
                if (parent instanceof MethodCallExpr) {
                    return OptionalOrRejection.reject();
                }
                if (parent instanceof EnclosedExpr) {
                    LOGGER.debug("{} is a no-op", EnclosedExpr.class);
                } else {
                    if (!(parent instanceof NodeWithType)) break;
                    Type type = ((NodeWithType)parent).getType();
                    Optional<ResolvedType> optResolvedType = ResolvedTypeHelpers.optResolvedType(type);
                    if (optResolvedType.isEmpty()) {
                        return OptionalOrRejection.reject();
                    }
                    if (ResolvedTypeHelpers.isAssignableBy(Float.class.getName(), optResolvedType.get())) {
                        needCastToDouble = Optional.of(child);
                    } else if (ResolvedTypeHelpers.isAssignableBy(Number.class.getName(), optResolvedType.get())) {
                        needCastToDouble = Optional.empty();
                    } else {
                        return OptionalOrRejection.reject();
                    }
                }
            }
            if (!(parent instanceof Expression)) break;
            child = (Expression)parent;
        }
        return OptionalOrRejection.optional(needCastToDouble);
    }
}

