/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.helpers;

import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class BinaryExprHelpers {
    protected BinaryExprHelpers() {
    }

    public static <S extends Expression, T extends Expression> Optional<Map.Entry<S, T>> findPair(BinaryExpr binaryExpr, Predicate<Expression> keyPredicate, Predicate<Expression> valuePredicate) {
        Expression left = binaryExpr.getLeft();
        Expression right = binaryExpr.getRight();
        if (keyPredicate.test(left) && valuePredicate.test(right)) {
            return Optional.of(Maps.immutableEntry((Object)left, (Object)right));
        }
        if (keyPredicate.test(right) && valuePredicate.test(left)) {
            return Optional.of(Maps.immutableEntry((Object)right, (Object)left));
        }
        return Optional.empty();
    }

    public static Optional<Expression> findAny(BinaryExpr binaryExpr, Predicate<Expression> operandPredicate, boolean cutThroughEnclosedExpr) {
        Expression left = binaryExpr.getLeft();
        if (cutThroughEnclosedExpr) {
            while (left.isEnclosedExpr()) {
                left = left.asEnclosedExpr().getInner();
            }
        }
        if (operandPredicate.test(left)) {
            return Optional.of(left);
        }
        Expression right = binaryExpr.getRight();
        if (cutThroughEnclosedExpr) {
            while (right.isEnclosedExpr()) {
                right = right.asEnclosedExpr().getInner();
            }
        }
        if (operandPredicate.test(right)) {
            return Optional.of(right);
        }
        return Optional.empty();
    }
}

