/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.TextBlockLiteralExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserMutator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class UseTextBlocks
extends AJavaparserMutator {
    public String minimalJavaVersion() {
        return "15";
    }

    public Optional<String> getCleanthatId() {
        return Optional.of("UseTextBlocks");
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        if (!(node instanceof Expression)) {
            return false;
        }
        Expression rootExp = (Expression)node;
        Optional<List<StringLiteralExpr>> optAsList = this.optAsList(rootExp);
        if (optAsList.isEmpty()) {
            return false;
        }
        List<StringLiteralExpr> listStringExpr = optAsList.get();
        String concat = listStringExpr.stream().map(StringLiteralExpr::asString).collect(Collectors.joining());
        List<String> rows = Arrays.asList(concat.split("\n"));
        if (rows.size() <= 1) {
            return false;
        }
        TextBlockLiteralExpr textBlock = new TextBlockLiteralExpr(concat);
        return node.replace((Node)textBlock);
    }

    private Optional<List<StringLiteralExpr>> optAsList(Expression expr) {
        if (expr.isStringLiteralExpr()) {
            return Optional.of(Collections.singletonList(expr.asStringLiteralExpr()));
        }
        if (expr.isIntegerLiteralExpr()) {
            IntegerLiteralExpr asIntExpr = expr.asIntegerLiteralExpr();
            String intAsString = Integer.toString(asIntExpr.asNumber().intValue());
            return Optional.of(Collections.singletonList(new StringLiteralExpr(intAsString)));
        }
        if (!expr.isBinaryExpr()) {
            return Optional.empty();
        }
        BinaryExpr binaryExpr = expr.asBinaryExpr();
        if (binaryExpr.getOperator() != BinaryExpr.Operator.PLUS) {
            return Optional.empty();
        }
        ArrayList underlyingStrings = new ArrayList();
        Expression left = binaryExpr.getLeft();
        Optional<List<StringLiteralExpr>> leftAsList = this.optAsList(left);
        if (leftAsList.isEmpty()) {
            return Optional.empty();
        }
        underlyingStrings.addAll(leftAsList.get());
        Expression right = binaryExpr.getRight();
        Optional<List<StringLiteralExpr>> rightAsList = this.optAsList(right);
        if (rightAsList.isEmpty()) {
            return Optional.empty();
        }
        underlyingStrings.addAll(rightAsList.get());
        return Optional.of(underlyingStrings);
    }
}

