/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyMeBefore;
import eu.solven.cleanthat.engine.java.refactorer.mutators.AUseXIsEmpty;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LiteralsFirstInComparisons;
import java.util.Optional;
import java.util.Set;

@ApplyMeBefore(value={LiteralsFirstInComparisons.class})
public class UseStringIsEmpty
extends AUseXIsEmpty {
    public boolean isDraft() {
        return false;
    }

    public String minimalJavaVersion() {
        return "1.6";
    }

    public Optional<String> getCleanthatId() {
        return Optional.of("UseStringIsEmpty");
    }

    @Override
    protected String getSizeMethod() {
        return "length";
    }

    @Override
    protected Set<Class<?>> getCompatibleTypes() {
        return Set.of(String.class);
    }

    @Override
    protected boolean processNotRecursively(Expression expr) {
        boolean replaced = super.processNotRecursively(expr);
        if (replaced) {
            return true;
        }
        if (!expr.isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr asMethodCall = expr.asMethodCallExpr();
        if (!"equals".equals(asMethodCall.getNameAsString()) && !"equalsIgnoreCase".equals(asMethodCall.getNameAsString())) {
            return false;
        }
        if (asMethodCall.getArguments().size() != 1 || !asMethodCall.getArgument(0).isLiteralStringValueExpr() || !"".equals(asMethodCall.getArgument(0).asLiteralStringValueExpr().getValue())) {
            return false;
        }
        Optional optScope = asMethodCall.getScope();
        if (!this.scopeHasRequiredType((Optional<Expression>)optScope, String.class)) {
            return false;
        }
        return this.tryReplace((Node)expr, (Node)new MethodCallExpr((Expression)optScope.get(), "isEmpty"));
    }
}

