/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserMutator;
import java.util.Optional;

public class UseIndexOfChar
extends AJavaparserMutator {
    public String minimalJavaVersion() {
        return "1";
    }

    public boolean isDraft() {
        return false;
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_performance.html#useindexofchar";
    }

    public Optional<String> getPmdId() {
        return Optional.of("UseIndexOfChar");
    }

    public String sonarUrl() {
        return "https://rules.sonarsource.com/java/RSPEC-1155";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-1155");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/use-is-empty-on-collections.html";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        if (!(node instanceof StringLiteralExpr)) {
            return false;
        }
        StringLiteralExpr stringLiteralExpr = (StringLiteralExpr)node;
        if (stringLiteralExpr.getParentNode().isEmpty()) {
            return false;
        }
        Node parentNode = (Node)stringLiteralExpr.getParentNode().get();
        if (!(parentNode instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr parentMethodCall = (MethodCallExpr)parentNode;
        String parentMethodAsString = parentMethodCall.getNameAsString();
        boolean isIndexOf = "indexOf".equals(parentMethodAsString);
        boolean isLastIndexOf = "lastIndexOf".equals(parentMethodAsString);
        if (!isIndexOf && !isLastIndexOf) {
            return false;
        }
        Optional optScope = parentMethodCall.getScope();
        if (!this.scopeHasRequiredType((Optional<Expression>)optScope, String.class)) {
            return false;
        }
        String stringLiteralExprValue = stringLiteralExpr.getValue();
        if (stringLiteralExprValue.isEmpty()) {
            if (isIndexOf) {
                return parentNode.replace((Node)new IntegerLiteralExpr("0"));
            }
            assert (isLastIndexOf);
            MethodCallExpr lengthMethodCall = new MethodCallExpr((Expression)optScope.get(), "length");
            return parentNode.replace((Node)lengthMethodCall);
        }
        if (stringLiteralExprValue.length() != 1) {
            return false;
        }
        return node.replace((Node)new CharLiteralExpr(stringLiteralExprValue.charAt(0)));
    }
}

