/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.Optional;

public class StreamMutatorHelpers {
    protected StreamMutatorHelpers() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<Statement> findSingleStatement(Statement maybeBlockorSingleStatement) {
        Statement singleStatement;
        if (maybeBlockorSingleStatement.isBlockStmt()) {
            BlockStmt asBlockStmt = maybeBlockorSingleStatement.asBlockStmt();
            if (asBlockStmt.getStatements().size() != 1) return Optional.empty();
            singleStatement = asBlockStmt.getStatement(0);
            return Optional.of(singleStatement);
        } else {
            singleStatement = maybeBlockorSingleStatement;
        }
        return Optional.of(singleStatement);
    }

    public static Optional<IfStmt> findSingleIfThenStmt(ForEachStmt forEachStmt) {
        Optional<Statement> optSingleStatement = StreamMutatorHelpers.findSingleStatement(forEachStmt.getBody());
        if (optSingleStatement.isEmpty()) {
            return Optional.empty();
        }
        Statement singleStatement = optSingleStatement.get();
        if (!singleStatement.isIfStmt() || singleStatement.asIfStmt().getElseStmt().isPresent()) {
            return Optional.empty();
        }
        IfStmt ifStmt = singleStatement.asIfStmt();
        return Optional.of(ifStmt);
    }
}

