/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserMutator;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAnyMatch
extends AJavaparserMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamAnyMatch.class);
    private static final String METHOD_FILTER = "filter";
    private static final String METHOD_FIND_ANY = "findAny";
    private static final String METHOD_IS_PRESENT = "isPresent";
    private static final String METHOD_IS_EMPTY = "isEmpty";
    private static final String METHOD_ANY_MATCH = "anyMatch";

    public String minimalJavaVersion() {
        return "1.8";
    }

    public boolean isDraft() {
        return false;
    }

    public Optional<String> getCleanthatId() {
        return Optional.of("StreamAnyMatch");
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-4034");
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        if (!(node instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr methodCall = (MethodCallExpr)node;
        String methodCallIdentifier = methodCall.getName().getIdentifier();
        if (!METHOD_IS_PRESENT.equals(methodCallIdentifier) && !METHOD_IS_EMPTY.equals(methodCallIdentifier)) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (optScope.isEmpty()) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        if (!(scope instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr scopeAsMethodCallExpr = (MethodCallExpr)scope;
        if (!METHOD_FIND_ANY.equals(scopeAsMethodCallExpr.getName().getIdentifier())) {
            return false;
        }
        Optional optParentScope = scopeAsMethodCallExpr.getScope();
        if (optParentScope.isEmpty()) {
            return false;
        }
        Expression parentScope = (Expression)optParentScope.get();
        if (!parentScope.isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr parentScopeAsMethodCallExpr = (MethodCallExpr)parentScope;
        if (!METHOD_FILTER.equals(parentScopeAsMethodCallExpr.getName().getIdentifier())) {
            return false;
        }
        Optional optGrandParentScope = parentScopeAsMethodCallExpr.getScope();
        if (optGrandParentScope.isEmpty()) {
            return false;
        }
        if (!this.scopeHasRequiredType((Optional<Expression>)optGrandParentScope, Stream.class)) {
            return false;
        }
        Expression grandParentScope = (Expression)optGrandParentScope.get();
        Expression filterPredicate = parentScopeAsMethodCallExpr.getArgument(0);
        boolean localTransformed = false;
        NodeList replaceArguments = new NodeList((Node[])new Expression[]{filterPredicate});
        MethodCallExpr replacement = new MethodCallExpr(grandParentScope, METHOD_ANY_MATCH, replaceArguments);
        if (METHOD_IS_EMPTY.equals(methodCallIdentifier)) {
            replacement = new UnaryExpr((Expression)replacement, UnaryExpr.Operator.LOGICAL_COMPLEMENT);
        }
        LOGGER.info("Turning {} into {}", (Object)methodCall, (Object)replacement);
        if (methodCall.replace((Node)replacement)) {
            localTransformed = true;
        }
        return localTransformed;
    }
}

