/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import java.util.Optional;
import java.util.stream.Stream;

public class SimplifyStartsWith
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "1.6";
    }

    public Optional<String> getPmdId() {
        return Optional.of("SimplifyStartsWith");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_performance.html#simplifystartswith";
    }

    public Optional<String> getCleanthatId() {
        return Optional.of("StringStartsWithChar");
    }

    @Override
    protected boolean processNotRecursively(Expression expr) {
        boolean isAndNotEmptyElseOrEmpty;
        if (!expr.isBinaryExpr()) {
            return false;
        }
        BinaryExpr binaryExpr = expr.asBinaryExpr();
        BinaryExpr.Operator operator = binaryExpr.getOperator();
        if (operator == BinaryExpr.Operator.AND) {
            isAndNotEmptyElseOrEmpty = true;
        } else if (operator == BinaryExpr.Operator.OR) {
            isAndNotEmptyElseOrEmpty = false;
        } else {
            return false;
        }
        Optional<MethodCallExpr> optStartsWith = this.findStartsWith(binaryExpr.getLeft(), binaryExpr.getRight());
        Optional<MethodCallExpr> optIsEmpty = this.findIsEmpty(binaryExpr.getLeft(), binaryExpr.getRight(), isAndNotEmptyElseOrEmpty);
        if (optStartsWith.isEmpty() || optIsEmpty.isEmpty()) {
            return false;
        }
        MethodCallExpr startsWithMethodCall = optStartsWith.get();
        MethodCallExpr isEmptyMethodCall = optIsEmpty.get();
        Object callIsEmptyExpr = isAndNotEmptyElseOrEmpty ? (Expression)isEmptyMethodCall.getParentNode().orElseThrow() : isEmptyMethodCall;
        Optional optRightScope = isEmptyMethodCall.getScope();
        Optional optLeftScope = startsWithMethodCall.getScope();
        if (optRightScope.isEmpty() || optLeftScope.isEmpty()) {
            return false;
        }
        if (!this.sameScope((Expression)optLeftScope.get(), (Expression)optRightScope.get())) {
            return false;
        }
        binaryExpr.setLeft((Expression)callIsEmptyExpr);
        binaryExpr.setRight((Expression)startsWithMethodCall);
        Character singleChar = this.optCallStartsWithSingleCharString(startsWithMethodCall).get();
        return this.replaceBy((Node)startsWithMethodCall, (Node)this.makeCharAtEqualsTo(optLeftScope, singleChar));
    }

    private Optional<MethodCallExpr> findIsEmpty(Expression left, Expression right, boolean isAndNotEmptyElseOrEmpty) {
        return Stream.of(left, right).flatMap(expr -> this.findIsEmpty((Expression)expr, isAndNotEmptyElseOrEmpty).stream()).findFirst();
    }

    private Optional<MethodCallExpr> findIsEmpty(Expression left, boolean isAndNotEmptyElseOrEmpty) {
        if (isAndNotEmptyElseOrEmpty) {
            if (!left.isUnaryExpr()) {
                return Optional.empty();
            }
            if (left.asUnaryExpr().getOperator() != UnaryExpr.Operator.LOGICAL_COMPLEMENT) {
                return Optional.empty();
            }
            left = left.asUnaryExpr().getExpression();
        }
        if (left.isMethodCallExpr() && this.isCallIsEmptyString(left.asMethodCallExpr())) {
            return Optional.of(left.asMethodCallExpr());
        }
        return Optional.empty();
    }

    private Optional<MethodCallExpr> findStartsWith(Expression left, Expression right) {
        if (left.isMethodCallExpr() && this.optCallStartsWithSingleCharString(left.asMethodCallExpr()).isPresent()) {
            return Optional.of(left.asMethodCallExpr());
        }
        if (right.isMethodCallExpr() && this.optCallStartsWithSingleCharString(right.asMethodCallExpr()).isPresent()) {
            return Optional.of(right.asMethodCallExpr());
        }
        return Optional.empty();
    }

    private BinaryExpr makeCharAtEqualsTo(Optional<Expression> optLeftScope, Character singleChar) {
        return new BinaryExpr((Expression)new MethodCallExpr(optLeftScope.get(), "charAt", new NodeList((Node[])new Expression[]{new IntegerLiteralExpr("0")})), (Expression)new CharLiteralExpr(singleChar.charValue()), BinaryExpr.Operator.EQUALS);
    }

    private boolean sameScope(Expression left, Expression right) {
        return left.isNameExpr() && right.isNameExpr() && left.asNameExpr().getNameAsString().equals(right.asNameExpr().getNameAsString());
    }

    private boolean isCallIsEmptyString(MethodCallExpr left) {
        return "isEmpty".equals(left.asMethodCallExpr().getNameAsString()) && this.scopeHasRequiredType((Optional<Expression>)left.asMethodCallExpr().getScope(), String.class);
    }

    private Optional<Character> optCallStartsWithSingleCharString(MethodCallExpr expr) {
        boolean hasSingleCharString;
        if (!"startsWith".equals(expr.getNameAsString()) || !this.scopeHasRequiredType((Optional<Expression>)expr.getScope(), String.class)) {
            return Optional.empty();
        }
        NodeList arguments = expr.getArguments();
        if (arguments.size() != 1) {
            return Optional.empty();
        }
        Expression singleArgument = expr.getArgument(0);
        boolean bl = hasSingleCharString = singleArgument.isStringLiteralExpr() && singleArgument.asStringLiteralExpr().getValue().length() == 1;
        if (hasSingleCharString) {
            return Optional.of(Character.valueOf(singleArgument.asStringLiteralExpr().getValue().charAt(0)));
        }
        return Optional.empty();
    }
}

