/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.PrimitiveType;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserStmtMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyMeBefore;
import eu.solven.cleanthat.engine.java.refactorer.meta.RepeatOnSuccess;
import eu.solven.cleanthat.engine.java.refactorer.mutators.RedundantLogicalComplementsInStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RepeatOnSuccess
@ApplyMeBefore(value={RedundantLogicalComplementsInStream.class})
public class SimplifyBooleanInitialization
extends AJavaparserStmtMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplifyBooleanInitialization.class);
    static final String ANY_MATCH = "anyMatch";

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Optional<String> getCleanthatId() {
        return Optional.of("SimplifyBooleanInitialization");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/enhanced-for-loop-to-stream-any-match.html";
    }

    @Override
    protected boolean processNotRecursively(Statement stmt) {
        if (!stmt.isBlockStmt()) {
            return false;
        }
        BlockStmt blockStmt = stmt.asBlockStmt();
        boolean result = false;
        for (int i = 0; i < blockStmt.getStatements().size() - 1; ++i) {
            Statement currentStmt = blockStmt.getStatement(i);
            Statement nextStmt = blockStmt.getStatement(i + 1);
            result |= this.trySimplifyingBoolean(currentStmt, nextStmt);
        }
        return result;
    }

    private boolean trySimplifyingBoolean(Statement currentStmt, Statement nextStmt) {
        if (!currentStmt.isExpressionStmt() || !currentStmt.asExpressionStmt().getExpression().isVariableDeclarationExpr()) {
            return false;
        }
        VariableDeclarationExpr assignExpr = currentStmt.asExpressionStmt().getExpression().asVariableDeclarationExpr();
        if (assignExpr.getVariables().size() != 1) {
            return false;
        }
        VariableDeclarator singleVariable = assignExpr.getVariable(0);
        if (!assignExpr.getElementType().isPrimitiveType() || !PrimitiveType.Primitive.BOOLEAN.equals((Object)assignExpr.getElementType().asPrimitiveType().getType())) {
            return false;
        }
        if (singleVariable.getInitializer().isEmpty()) {
            return false;
        }
        if (!((Expression)singleVariable.getInitializer().get()).isBooleanLiteralExpr()) {
            return false;
        }
        if (!nextStmt.isIfStmt() || nextStmt.asIfStmt().getElseStmt().isPresent()) {
            return false;
        }
        IfStmt ifStmt = nextStmt.asIfStmt();
        Optional<AssignExpr> optIfAssignExpr = this.searchSingleAssignExpr(ifStmt.getThenStmt());
        if (optIfAssignExpr.isEmpty()) {
            return false;
        }
        AssignExpr ifAssignExpr = optIfAssignExpr.get();
        if (this.isAssignOperator(ifAssignExpr) || !ifAssignExpr.getTarget().isNameExpr() || !ifAssignExpr.getTarget().asNameExpr().getNameAsString().equals(singleVariable.getNameAsString())) {
            return false;
        }
        if (!ifAssignExpr.getValue().isBooleanLiteralExpr()) {
            return false;
        }
        boolean defaultValue = ((Expression)singleVariable.getInitializer().get()).asBooleanLiteralExpr().getValue();
        boolean ifTrueValue = ifAssignExpr.getValue().asBooleanLiteralExpr().getValue();
        if (!defaultValue && ifTrueValue) {
            if (this.tryRemove((Node)ifStmt)) {
                singleVariable.setInitializer(ifStmt.getCondition());
                return true;
            }
            LOGGER.debug("Issue removing `{}`", (Object)ifStmt);
        } else if (defaultValue && !ifTrueValue) {
            if (this.tryRemove((Node)ifStmt)) {
                singleVariable.setInitializer((Expression)new UnaryExpr(ifStmt.getCondition(), UnaryExpr.Operator.LOGICAL_COMPLEMENT));
                return true;
            }
            LOGGER.debug("Issue removing `{}`", (Object)ifStmt);
        }
        return false;
    }

    private boolean isAssignOperator(AssignExpr ifAssignExpr) {
        return ifAssignExpr.getOperator() != AssignExpr.Operator.ASSIGN;
    }

    private Optional<AssignExpr> searchSingleAssignExpr(Statement thenStmt) {
        if (thenStmt.isExpressionStmt() && thenStmt.asExpressionStmt().getExpression().isAssignExpr()) {
            return Optional.of(thenStmt.asExpressionStmt().getExpression().asAssignExpr());
        }
        if (thenStmt.isBlockStmt() && thenStmt.asBlockStmt().getStatements().size() == 1) {
            Statement singleStmt = thenStmt.asBlockStmt().getStatement(0);
            return this.searchSingleAssignExpr(singleStmt);
        }
        return Optional.empty();
    }
}

