/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserMutator;
import java.util.Optional;

public class RemoveExplicitCallToSuper
extends AJavaparserMutator {
    public String minimalJavaVersion() {
        return "1";
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("RemoveExplicitCallToSuper");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/remove-explicit-call-to-super.html";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        if (!(node instanceof ConstructorDeclaration)) {
            return false;
        }
        ConstructorDeclaration constructor = (ConstructorDeclaration)node;
        BlockStmt body = constructor.getBody();
        if (body.getStatements().isEmpty()) {
            return false;
        }
        Statement firstStatement = body.getStatement(0);
        if (!firstStatement.isExplicitConstructorInvocationStmt()) {
            return false;
        }
        if (firstStatement.asExplicitConstructorInvocationStmt().getArguments().isEmpty()) {
            return this.tryRemove((Node)firstStatement);
        }
        return false;
    }
}

