/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import java.util.Optional;
import java.util.Set;

public class RemoveDoubleNegation
extends AJavaparserExprMutator {
    private static final Set<UnaryExpr.Operator> REDUNCANT_IF_DOUBLED = ImmutableSet.of((Object)UnaryExpr.Operator.LOGICAL_COMPLEMENT, (Object)UnaryExpr.Operator.MINUS, (Object)UnaryExpr.Operator.PLUS, (Object)UnaryExpr.Operator.BITWISE_COMPLEMENT);

    public String minimalJavaVersion() {
        return "1";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2761");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("RemoveDoubleNegation");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/remove-double-negation.html";
    }

    @Override
    protected boolean processNotRecursively(Expression expr) {
        if (!expr.isUnaryExpr()) {
            return false;
        }
        UnaryExpr unaryExpr = expr.asUnaryExpr();
        UnaryExpr.Operator unaryOperator = unaryExpr.getOperator();
        if (!REDUNCANT_IF_DOUBLED.contains(unaryOperator)) {
            return false;
        }
        if (!unaryExpr.getParentNode().isPresent() || !(unaryExpr.getParentNode().get() instanceof UnaryExpr)) {
            return false;
        }
        UnaryExpr parentUnaryExpr = (UnaryExpr)unaryExpr.getParentNode().get();
        if (parentUnaryExpr.getOperator() != unaryOperator) {
            return false;
        }
        return this.tryReplace((Node)parentUnaryExpr, (Node)unaryExpr.getExpression());
    }
}

