/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import java.util.Collection;
import java.util.Optional;

public class RemoveAllToClearCollection
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "1.2";
    }

    public Optional<String> getSpotBugsId() {
        return Optional.of("DMI_USING_REMOVEALL_TO_CLEAR_COLLECTION");
    }

    public String spotBugsUrl() {
        return "https://spotbugs.readthedocs.io/en/stable/bugDescriptions.html#dmi-using-removeall-to-clear-collection";
    }

    @Override
    protected boolean processNotRecursively(Expression expr) {
        if (!expr.isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCall = expr.asMethodCallExpr();
        if (!"removeAll".equals(methodCall.getNameAsString())) {
            return false;
        }
        if (!this.scopeHasRequiredType((Optional<Expression>)methodCall.getScope(), Collection.class)) {
            return false;
        }
        if (methodCall.getArguments().size() != 1) {
            return false;
        }
        if (this.isMethodReturnUsed(methodCall)) {
            return false;
        }
        Expression scope = (Expression)methodCall.getScope().get();
        if (!scope.equals((Object)methodCall.getArgument(0))) {
            return false;
        }
        return this.replaceBy((Node)methodCall, (Node)new MethodCallExpr(scope, "clear"));
    }
}

