/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import java.util.Optional;
import java.util.stream.Stream;

public class RedundantLogicalComplementsInStream
extends AJavaparserExprMutator {
    static final String ANY_MATCH = "anyMatch";

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("RedundantLogicalComplementsInStream");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/enhanced-for-loop-to-stream-any-match.html";
    }

    @Override
    protected boolean processNotRecursively(Expression expr) {
        if (!expr.isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCall = expr.asMethodCallExpr();
        if (!ANY_MATCH.equals(methodCall.getNameAsString()) || methodCall.getArguments().size() != 1) {
            return false;
        }
        if (!this.scopeHasRequiredType((Optional<Expression>)methodCall.getScope(), Stream.class)) {
            return false;
        }
        MethodCallExpr nearestMethodCallAncestor = methodCall;
        while (nearestMethodCallAncestor.getParentNode().isPresent() && nearestMethodCallAncestor.getParentNode().get() instanceof MethodCallExpr) {
            nearestMethodCallAncestor = (MethodCallExpr)nearestMethodCallAncestor.getParentNode().get();
        }
        if (nearestMethodCallAncestor.getParentNode().isEmpty() || !(nearestMethodCallAncestor.getParentNode().get() instanceof UnaryExpr)) {
            return false;
        }
        UnaryExpr unaryExpr = (UnaryExpr)nearestMethodCallAncestor.getParentNode().get();
        if (unaryExpr.getOperator() != UnaryExpr.Operator.LOGICAL_COMPLEMENT) {
            return false;
        }
        if (!this.tryReplace((Node)unaryExpr, (Node)nearestMethodCallAncestor)) {
            return false;
        }
        Expression firstArgument = methodCall.getArgument(0);
        Optional<Expression> optNegatedPredicate = this.searchNegatingPredicate(firstArgument);
        if (optNegatedPredicate.isPresent() && optNegatedPredicate.get().getParentNode().isPresent()) {
            Expression negatedPredicate = optNegatedPredicate.get();
            if (this.tryReplace((Node)negatedPredicate.getParentNode().get(), (Node)negatedPredicate)) {
                methodCall.setName("allMatch");
            } else {
                methodCall.setName("noneMatch");
            }
        } else {
            methodCall.setName("noneMatch");
        }
        return true;
    }

    private Optional<Expression> searchNegatingPredicate(Expression firstArgument) {
        if (!firstArgument.isLambdaExpr()) {
            return Optional.empty();
        }
        LambdaExpr lambda = firstArgument.asLambdaExpr();
        if (lambda.getExpressionBody().isEmpty()) {
            return Optional.empty();
        }
        Optional optPredicate = lambda.getExpressionBody();
        if (optPredicate.isEmpty()) {
            return Optional.empty();
        }
        Expression predicate = (Expression)optPredicate.get();
        if (predicate.isUnaryExpr() && predicate.asUnaryExpr().getOperator() == UnaryExpr.Operator.LOGICAL_COMPLEMENT) {
            return Optional.of(predicate.asUnaryExpr().getExpression());
        }
        return Optional.empty();
    }
}

