/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import java.util.Optional;

public class PrimitiveWrapperInstantiation
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "1.5";
    }

    public Optional<String> getCleanthatId() {
        return Optional.of("BoxedPrimitiveConstructor");
    }

    public Optional<String> getPmdId() {
        return Optional.of("PrimitiveWrapperInstantiation");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_bestpractices.html#primitivewrapperinstantiation";
    }

    @Override
    protected boolean processNotRecursively(Expression expr) {
        if (!expr.isObjectCreationExpr()) {
            return false;
        }
        ObjectCreationExpr objectCreationExpr = expr.asObjectCreationExpr();
        ClassOrInterfaceType type = objectCreationExpr.getType();
        if (!this.isBoxedPrimitive(type)) {
            return false;
        }
        return objectCreationExpr.replace((Node)new MethodCallExpr((Expression)new NameExpr(type.getName()), "valueOf", objectCreationExpr.getArguments()));
    }

    private boolean isBoxedPrimitive(ClassOrInterfaceType type) {
        return type.getScope().isEmpty() && type.isBoxedType();
    }
}

