/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserMutator;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalNotEmpty
extends AJavaparserMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionalNotEmpty.class);
    private static final String ID_NOTEMPTY = "OptionalNotEmpty";
    private static final String ID_ISPRESENT = "OptionalIsPresent";
    private static final String METHOD_IS_PRESENT = "isPresent";
    private static final String METHOD_IS_EMPTY = "isEmpty";

    public String minimalJavaVersion() {
        return "11";
    }

    public boolean isDraft() {
        return false;
    }

    public Set<String> getIds() {
        return ImmutableSet.of((Object)ID_NOTEMPTY, (Object)ID_ISPRESENT);
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        if (!(node instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr methodCall = (MethodCallExpr)node;
        String methodCallIdentifier = methodCall.getName().getIdentifier();
        if (!METHOD_IS_EMPTY.equals(methodCallIdentifier) && !METHOD_IS_PRESENT.equals(methodCallIdentifier)) {
            return false;
        }
        Optional optParent = methodCall.getParentNode();
        if (methodCall.getScope().isEmpty() || optParent.isEmpty() || !(optParent.get() instanceof UnaryExpr)) {
            return false;
        }
        UnaryExpr unaryExpr = (UnaryExpr)optParent.get();
        if (!"LOGICAL_COMPLEMENT".equals(unaryExpr.getOperator().name())) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (!this.scopeHasRequiredType((Optional<Expression>)optScope, Optional.class)) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        String newMethod = METHOD_IS_EMPTY.equals(methodCallIdentifier) ? METHOD_IS_PRESENT : METHOD_IS_EMPTY;
        boolean localTransformed = false;
        MethodCallExpr replacement = new MethodCallExpr(scope, newMethod);
        LOGGER.info("Turning {} into {}", (Object)unaryExpr, (Object)replacement);
        if (unaryExpr.replace((Node)replacement)) {
            localTransformed = true;
        }
        return localTransformed;
    }
}

