/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutatorDescriber;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralsFirstInComparisons
extends AJavaparserMutator
implements IMutatorDescriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiteralsFirstInComparisons.class);
    private static final String METHOD_EQUALS = "equals";

    @Override
    public String minimalJavaVersion() {
        return "1";
    }

    public boolean isDraft() {
        return false;
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_bestpractices.html#literalsfirstincomparisons";
    }

    public Optional<String> getPmdId() {
        return Optional.of("LiteralsFirstInComparisons");
    }

    @Override
    public boolean isPreventingExceptions() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean processNotRecursively(Node node) {
        boolean stringScopeOnly;
        if (!(node instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr methodCall = (MethodCallExpr)node;
        if (methodCall.getArguments().size() != 1) {
            return false;
        }
        Expression singleArgument = methodCall.getArgument(0);
        String methodCallName = methodCall.getName().getIdentifier();
        if (singleArgument instanceof ObjectCreationExpr && METHOD_EQUALS.equals(methodCallName)) {
            LOGGER.debug("This is a !String method which can be swapped");
            stringScopeOnly = false;
        } else if (singleArgument instanceof StringLiteralExpr) {
            LOGGER.debug("This is a String method which can be swapped");
            if (METHOD_EQUALS.equals(methodCallName)) {
                stringScopeOnly = false;
            } else {
                if (!this.isSwitchableStringMethod(methodCallName)) return false;
                stringScopeOnly = true;
            }
        } else if (METHOD_EQUALS.equals(methodCallName) && (singleArgument instanceof FieldAccessExpr || singleArgument instanceof NameExpr)) {
            stringScopeOnly = false;
        } else {
            if (!(singleArgument instanceof StringLiteralExpr) || !this.isCompareStringMethod(methodCallName)) return false;
            LOGGER.debug("TODO replace x.compareTo('bar')<0 by 'bar'.compareTo(x)>0");
            return false;
        }
        Expression argument = singleArgument;
        LOGGER.debug("Find a hardcoded string : {}", (Object)argument);
        Optional optScope = methodCall.getScope();
        if (optScope.isEmpty()) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        if (stringScopeOnly && !this.isStringScope(scope)) {
            return false;
        }
        if (!this.mayBeNull(scope)) {
            return false;
        }
        if (this.mayBeNull(argument) && (!this.isStaticField(argument) || this.isStaticField(scope))) return false;
        MethodCallExpr replacement = new MethodCallExpr(argument, methodCallName, new NodeList((Node[])new Expression[]{scope}));
        return this.tryReplace(node, (Node)replacement);
    }

    private boolean mayBeNull(Expression expr) {
        return !(expr instanceof StringLiteralExpr) && !(expr instanceof ObjectCreationExpr) && !(expr instanceof SuperExpr) && !(expr instanceof ThisExpr);
    }

    private boolean isStaticField(Expression singleArgument) {
        boolean argumentIsField;
        if (singleArgument instanceof NameExpr || singleArgument instanceof FieldAccessExpr) {
            Optional<ResolvedDeclaration> optResolved = this.optResolved(singleArgument);
            if (optResolved.isEmpty()) {
                return LiteralsFirstInComparisons.looksLikeAConstant(((NodeWithSimpleName)singleArgument).getName());
            }
            ResolvedDeclaration resolved = optResolved.get();
            argumentIsField = resolved.isField() && resolved.asField().isStatic();
        } else {
            argumentIsField = false;
        }
        return argumentIsField;
    }

    private static boolean looksLikeAConstant(SimpleName name) {
        return name.asString().matches("[A-Z0-9_]+");
    }

    private boolean isStringScope(Expression scope) {
        Optional<ResolvedType> optType = this.optResolvedType(scope);
        if (optType.isEmpty()) {
            return false;
        }
        ResolvedType type = optType.get();
        if (type.isConstraint()) {
            type = type.asConstraintType().getBound();
        }
        return type.isReferenceType() && type.asReferenceType().getQualifiedName().equals(String.class.getName());
    }

    private boolean isSwitchableStringMethod(String methodCallName) {
        return METHOD_EQUALS.equals(methodCallName) || "equalsIgnoreCase".equals(methodCallName) || "contentEquals".equals(methodCallName);
    }

    private boolean isCompareStringMethod(String methodCallName) {
        return "compareTo".equals(methodCallName) || "compareToIgnoreCase".equals(methodCallName);
    }
}

