/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyMeBefore;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaIsMethodReference;
import java.util.Optional;

@ApplyMeBefore(value={LambdaIsMethodReference.class})
public class LambdaReturnsSingleStatement
extends AJavaparserExprMutator {
    public boolean isDraft() {
        return true;
    }

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Optional<String> getCleanthatId() {
        return Optional.of("LambdaReturnsSingleStatement");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_codestyle.html#unnecessaryfullyqualifiedname";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-1602");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("StatementLambdaToExpression");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/statement-lambda-to-expression.html";
    }

    @Override
    protected boolean processNotRecursively(Expression expr) {
        if (!expr.isLambdaExpr()) {
            return false;
        }
        LambdaExpr lambdaExpr = expr.asLambdaExpr();
        Statement body = lambdaExpr.getBody();
        if (!(body instanceof BlockStmt)) {
            return false;
        }
        BlockStmt lambdaBlockStmt = (BlockStmt)body;
        if (lambdaBlockStmt.getStatements().size() == 1) {
            if (lambdaBlockStmt.getStatement(0) instanceof ReturnStmt) {
                ReturnStmt returnStmt = (ReturnStmt)lambdaBlockStmt.getStatement(0);
                Optional returnedExpr = returnStmt.getExpression();
                if (returnedExpr.isEmpty()) {
                    return false;
                }
                return this.changeExpression(lambdaExpr, (Expression)returnedExpr.get(), returnStmt.getComment());
            }
            if (lambdaBlockStmt.getStatement(0) instanceof ExpressionStmt) {
                ExpressionStmt exprStmt = (ExpressionStmt)lambdaBlockStmt.getStatement(0);
                return this.changeExpression(lambdaExpr, exprStmt.getExpression(), exprStmt.getComment());
            }
            return false;
        }
        return false;
    }

    private boolean changeExpression(LambdaExpr lambdaExpr, Expression expr, Optional<Comment> optComment) {
        if (optComment.isPresent()) {
            return false;
        }
        LambdaExpr newLambdaExpr = new LambdaExpr();
        newLambdaExpr.setEnclosingParameters(lambdaExpr.isEnclosingParameters());
        lambdaExpr.getComment().ifPresent(arg_0 -> ((LambdaExpr)newLambdaExpr).setComment(arg_0));
        newLambdaExpr.setParameters(lambdaExpr.getParameters());
        newLambdaExpr.setBody((Statement)new ExpressionStmt(expr));
        return this.tryReplace((Node)lambdaExpr, (Node)newLambdaExpr);
    }
}

