/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserStmtMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyMeBefore;
import eu.solven.cleanthat.engine.java.refactorer.mutators.SimplifyBooleanInitialization;
import eu.solven.cleanthat.engine.java.refactorer.mutators.StreamMutatorHelpers;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplyMeBefore(value={SimplifyBooleanInitialization.class})
public class EnhancedForLoopToStreamAnyMatch
extends AJavaparserStmtMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnhancedForLoopToStreamAnyMatch.class);
    static final String ANY_MATCH = "anyMatch";

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("EnhancedForLoopToStreamAnyMatch");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/enhanced-for-loop-to-stream-any-match.html";
    }

    @Override
    protected boolean processNotRecursively(Statement stmt) {
        if (!stmt.isForEachStmt()) {
            return false;
        }
        ForEachStmt forEachStmt = stmt.asForEachStmt();
        Optional<IfStmt> optIfStmt = StreamMutatorHelpers.findSingleIfThenStmt(forEachStmt);
        if (optIfStmt.isEmpty()) {
            return false;
        }
        IfStmt ifStmt = optIfStmt.get();
        Statement thenStmt = ifStmt.getThenStmt();
        if (!thenStmt.isBlockStmt()) {
            return false;
        }
        BlockStmt thenAsBlockStmt = thenStmt.asBlockStmt();
        if (thenAsBlockStmt.getStatements().isEmpty()) {
            return false;
        }
        Statement lastStmt = thenAsBlockStmt.getStatement(thenAsBlockStmt.getStatements().size() - 1);
        if (lastStmt.isReturnStmt()) {
            NameExpr variableName = forEachStmt.getVariableDeclarator().getNameAsExpression();
            Optional optVariableIsReturned = thenAsBlockStmt.findFirst(NameExpr.class, n -> variableName.equals(n));
            if (optVariableIsReturned.isPresent()) {
                return false;
            }
            return this.replaceForEachIfByIfStream(forEachStmt, ifStmt, thenAsBlockStmt);
        }
        if (lastStmt.isBreakStmt()) {
            boolean breakIsRemoved = this.tryRemove((Node)lastStmt);
            if (!breakIsRemoved) {
                return false;
            }
            boolean replaced = this.replaceForEachIfByIfStream(forEachStmt, ifStmt, thenAsBlockStmt);
            if (!replaced) {
                LOGGER.debug("We try restoring the `break` as we failed replacing the `forEach(if)`");
                if (!thenAsBlockStmt.getStatements().add((Node)lastStmt)) {
                    throw new IllegalStateException("We corrupted `" + stmt + "` by failing restoring `" + lastStmt + "`");
                }
            }
            return replaced;
        }
        return false;
    }

    protected boolean replaceForEachIfByIfStream(ForEachStmt forEachStmt, IfStmt ifStmt, BlockStmt thenAsBlockStmt) {
        MethodCallExpr withStream = new MethodCallExpr(forEachStmt.getIterable(), "stream");
        VariableDeclarator variable = (VariableDeclarator)forEachStmt.getVariable().getVariables().get(0);
        LambdaExpr lambdaExpr = EnhancedForLoopToStreamAnyMatch.ifConditionToLambda(ifStmt, variable);
        MethodCallExpr withStream2 = new MethodCallExpr((Expression)withStream, ANY_MATCH, new NodeList((Node[])new Expression[]{lambdaExpr}));
        IfStmt newif = new IfStmt((Expression)withStream2, (Statement)thenAsBlockStmt, null);
        return this.tryReplace((Node)forEachStmt, (Node)newif);
    }

    public static LambdaExpr ifConditionToLambda(IfStmt ifStmt, VariableDeclarator variable) {
        Parameter parameter = new Parameter((Type)new UnknownType(), variable.getName());
        Expression condition = ifStmt.getCondition();
        LambdaExpr lambdaExpr = new LambdaExpr(parameter, condition);
        return lambdaExpr;
    }
}

