/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserMutator;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyControlStatement
extends AJavaparserMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmptyControlStatement.class);

    public String minimalJavaVersion() {
        return "1";
    }

    public Set<String> getPmdIds() {
        return Set.of("EmptyControlStatement", "EmptyStatementBlock");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_codestyle.html#emptycontrolstatement";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-1116");
    }

    public Optional<String> getCheckstyleId() {
        return Optional.of("EmptyStatementCheck");
    }

    public String checkstyleUrl() {
        return "https://javadoc.io/static/com.puppycrawl.tools/checkstyle/8.37/com/puppycrawl/tools/checkstyle/checks/coding/EmptyStatementCheck.html";
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("RemoveEmptyStatement");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/remove-empty-statement.html";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        Node parentNode;
        Optional optParentNode;
        if (!(node instanceof BlockStmt)) {
            return false;
        }
        BlockStmt blockStmt = (BlockStmt)node;
        boolean removed = false;
        while (!(optParentNode = blockStmt.getParentNode()).isEmpty() && (parentNode = (Node)optParentNode.get()) instanceof BlockStmt) {
            BlockStmt parentNodeAsBlockStmt = (BlockStmt)parentNode;
            if (!blockStmt.getChildNodes().isEmpty() || !(removed = blockStmt.remove())) break;
            blockStmt = parentNodeAsBlockStmt;
        }
        if (blockStmt.getChildNodes().isEmpty() && blockStmt.getParentNode().isPresent()) {
            LOGGER.debug("Encountered an empty initializer in an anonymous class?");
            if (blockStmt.getParentNode().get() instanceof InitializerDeclaration) {
                InitializerDeclaration parentInitializerDeclaration = (InitializerDeclaration)blockStmt.getParentNode().get();
                removed |= parentInitializerDeclaration.remove();
            }
        }
        return removed;
    }
}

