/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.resolution.types.ResolvedType;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserMutator;
import eu.solven.cleanthat.engine.java.refactorer.mutators.UseCollectionIsEmpty;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTempFilesUsingNio
extends AJavaparserMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UseCollectionIsEmpty.class);

    public String minimalJavaVersion() {
        return "1.7";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2976");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/create-temp-files-using-java-nio.html";
    }

    public String getId() {
        return "CreateTempFilesUsingNio";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        if (!(node instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr methodCallExpr = (MethodCallExpr)node;
        if (!"createTempFile".equals(methodCallExpr.getName().getIdentifier())) {
            return false;
        }
        Optional<Boolean> optIsStatic = this.mayStaticCall(methodCallExpr);
        if (optIsStatic.isPresent() && !optIsStatic.get().booleanValue()) {
            return false;
        }
        Optional optScope = methodCallExpr.getScope();
        if (optScope.isPresent()) {
            Optional<ResolvedType> type = this.optResolvedType((Expression)optScope.get());
            if (type.isEmpty() || !"java.io.File".equals(type.get().asReferenceType().getQualifiedName())) {
                return false;
            }
            LOGGER.debug("Found : {}", (Object)node);
            if (this.process(methodCallExpr)) {
                return true;
            }
        }
        return false;
    }

    private Optional<Boolean> mayStaticCall(MethodCallExpr methodCallExpr) {
        try {
            return Optional.of(methodCallExpr.resolve().isStatic());
        }
        catch (Exception e) {
            LOGGER.debug("arg", (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean process(MethodCallExpr methodExp) {
        Optional<Object> optToPath;
        NodeList arguments = methodExp.getArguments();
        NameExpr newStaticClass = new NameExpr("Files");
        String newStaticMethod = "createTempFile";
        int minArgSize = 2;
        if (arguments.size() == minArgSize) {
            LOGGER.debug("Add java.nio.file.Files to import");
            methodExp.tryAddImportToParentCompilationUnit(Files.class);
            optToPath = Optional.of(new MethodCallExpr((Expression)newStaticClass, newStaticMethod, methodExp.getArguments()));
        } else if (arguments.size() == minArgSize + 1) {
            Expression arg0 = methodExp.getArgument(0);
            Expression arg1 = methodExp.getArgument(1);
            Expression arg3 = methodExp.getArgument(2);
            if (arg3.isObjectCreationExpr()) {
                methodExp.tryAddImportToParentCompilationUnit(Paths.class);
                ObjectCreationExpr objectCreation = (ObjectCreationExpr)methodExp.getArgument(minArgSize);
                NodeList objectCreationArguments = objectCreation.getArguments();
                NodeList replaceArguments = new NodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr("Paths"), "get", objectCreationArguments), arg0, arg1});
                optToPath = Optional.of(new MethodCallExpr((Expression)newStaticClass, newStaticMethod, replaceArguments));
            } else if (arg3.isNameExpr()) {
                BinaryExpr fileIsNull = new BinaryExpr(arg3, (Expression)new NullLiteralExpr(), BinaryExpr.Operator.EQUALS);
                NodeList replaceArgumentsIfNull = new NodeList((Node[])new Expression[]{arg0, arg1});
                MethodCallExpr callIfNull = new MethodCallExpr((Expression)newStaticClass, newStaticMethod, replaceArgumentsIfNull);
                NodeList replaceArgumentsNotNull = new NodeList((Node[])new Expression[]{new MethodCallExpr(arg3, "toPath"), arg0, arg1});
                MethodCallExpr callNotNull = new MethodCallExpr((Expression)newStaticClass, newStaticMethod, replaceArgumentsNotNull);
                EnclosedExpr enclosedTernary = new EnclosedExpr((Expression)new ConditionalExpr((Expression)fileIsNull, (Expression)callIfNull, (Expression)callNotNull));
                optToPath = Optional.of(enclosedTernary);
            } else if (arg3.isNullLiteralExpr()) {
                NodeList replaceArguments = new NodeList((Node[])new Expression[]{arg0, arg1});
                optToPath = Optional.of(new MethodCallExpr((Expression)newStaticClass, newStaticMethod, replaceArguments));
            } else {
                optToPath = Optional.empty();
            }
        } else {
            optToPath = Optional.empty();
        }
        optToPath.ifPresent(toPath -> {
            methodExp.tryAddImportToParentCompilationUnit(Files.class);
            LOGGER.info("Turning {} into {}", (Object)methodExp, toPath);
            methodExp.replace((Node)new MethodCallExpr(toPath, "toFile"));
        });
        return optToPath.isPresent();
    }
}

