/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import java.util.List;
import java.util.Optional;

public class CollectionToOptional
extends AJavaparserExprMutator {
    public Optional<String> getCleanthatId() {
        return Optional.of("CollectionToOptional");
    }

    @Override
    protected boolean processNotRecursively(Expression expr) {
        if (!expr.isConditionalExpr()) {
            return false;
        }
        ConditionalExpr conditionalExpr = expr.asConditionalExpr();
        Expression conditionExpr = conditionalExpr.getCondition();
        Expression thenExpr = conditionalExpr.getThenExpr();
        Expression elseExpr = conditionalExpr.getElseExpr();
        if (!(conditionExpr.isMethodCallExpr() && thenExpr.isMethodCallExpr() && elseExpr.isMethodCallExpr())) {
            return false;
        }
        MethodCallExpr conditionMethod = conditionExpr.asMethodCallExpr();
        MethodCallExpr thenMethod = thenExpr.asMethodCallExpr();
        MethodCallExpr elseMethod = elseExpr.asMethodCallExpr();
        if (!"isEmpty".equals(conditionMethod.getNameAsString()) || !this.scopeHasRequiredType((Optional<Expression>)conditionMethod.getScope(), List.class)) {
            return false;
        }
        if (!"Optional.empty()".equals(thenMethod.toString()) || !this.hasImported(expr, "java.util.Optional")) {
            return false;
        }
        if (!"Optional.of(list.get(0))".equals(elseMethod.toString())) {
            return false;
        }
        return this.tryReplace((Node)expr, (Node)new MethodCallExpr((Expression)new MethodCallExpr((Expression)conditionMethod.getScope().get(), "stream"), "findFirst"));
    }

    private boolean hasImported(Expression expr, String imported) {
        Optional optCompilationUnit = expr.findCompilationUnit();
        if (optCompilationUnit.isEmpty()) {
            return false;
        }
        return ((CompilationUnit)optCompilationUnit.get()).getImports().stream().anyMatch(importDecl -> !importDecl.isAsterisk() && !importDecl.isStatic() && imported.equals(importDecl.getNameAsString()));
    }
}

