/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserMutator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvoidInlineConditionals
extends AJavaparserMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvoidInlineConditionals.class);

    public boolean isDraft() {
        return false;
    }

    public Optional<String> getCheckstyleId() {
        return Optional.of("AvoidInlineConditionals");
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-3358");
    }

    public String checkstyleUrl() {
        return "https://checkstyle.sourceforge.io/config_coding.html#AvoidInlineConditionals";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        if (!(node instanceof ConditionalExpr)) {
            return false;
        }
        ConditionalExpr ternary = (ConditionalExpr)node;
        if (ternary.getParentNode().isEmpty()) {
            return false;
        }
        Node parent = (Node)ternary.getParentNode().get();
        Expression condition = ternary.getCondition();
        while (condition instanceof EnclosedExpr) {
            condition = ((EnclosedExpr)condition).getInner();
        }
        if (parent instanceof VariableDeclarator) {
            if (parent.getParentNode().isEmpty()) {
                return false;
            }
            Node grandParent = (Node)parent.getParentNode().get();
            if (!(grandParent instanceof VariableDeclarationExpr)) {
                return false;
            }
            if (grandParent.getParentNode().isEmpty()) {
                return false;
            }
            Node grandGrandParent = (Node)grandParent.getParentNode().get();
            if (!(grandGrandParent instanceof ExpressionStmt)) {
                return false;
            }
            if (grandGrandParent.getParentNode().isEmpty()) {
                return false;
            }
            Node grandGrandGrandParent = (Node)grandGrandParent.getParentNode().get();
            if (!(grandGrandGrandParent instanceof BlockStmt)) {
                return false;
            }
            VariableDeclarationExpr variableDeclExpr = (VariableDeclarationExpr)grandParent;
            if (variableDeclExpr.getVariables().size() != 1) {
                return false;
            }
            if (variableDeclExpr.getElementType().isVarType()) {
                return false;
            }
            VariableDeclarator variableDeclarator = (VariableDeclarator)variableDeclExpr.getVariables().get(0);
            SimpleName variableName = variableDeclarator.getName();
            BlockStmt grandGrandGrandParentBlockStmt = (BlockStmt)grandGrandGrandParent;
            int indexOfVariableInParent = grandGrandGrandParentBlockStmt.getStatements().indexOf((Object)grandGrandParent);
            if (indexOfVariableInParent < 0) {
                LOGGER.error("Issue searching for {} inside {}", (Object)grandGrandParent, (Object)grandGrandGrandParentBlockStmt);
                return false;
            }
            VariableDeclarator newVariableDeclarator = new VariableDeclarator(variableDeclarator.getType(), variableName);
            grandGrandGrandParentBlockStmt.addStatement(indexOfVariableInParent, (Expression)new VariableDeclarationExpr(newVariableDeclarator));
            Expression thenExpr = ternary.getThenExpr();
            Expression elseExpr = ternary.getElseExpr();
            IfStmt newNode = new IfStmt(condition, (Statement)this.wrapThenElse(thenExpr, variableName), (Statement)this.wrapThenElse(elseExpr, variableName));
            return grandGrandParent.replace((Node)newNode);
        }
        if (parent instanceof ReturnStmt) {
            Expression thenExpr = ternary.getThenExpr();
            Expression elseExpr = ternary.getElseExpr();
            IfStmt newNode = new IfStmt(condition, (Statement)new BlockStmt(new NodeList((Node[])new Statement[]{new ReturnStmt(thenExpr)})), (Statement)new BlockStmt(new NodeList((Node[])new Statement[]{new ReturnStmt(elseExpr)})));
            return parent.replace((Node)newNode);
        }
        return false;
    }

    private BlockStmt wrapThenElse(Expression thenExpr, SimpleName variableName) {
        return new BlockStmt(new NodeList((Node[])new Statement[]{new ExpressionStmt((Expression)new AssignExpr((Expression)new NameExpr(variableName), thenExpr, AssignExpr.Operator.ASSIGN))}));
    }
}

