/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.resolution.types.ResolvedType;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserMutator;
import eu.solven.cleanthat.engine.java.refactorer.mutators.StreamAnyMatch;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArraysDotStream
extends AJavaparserMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamAnyMatch.class);
    private static final String METHOD_ASLIST = "asList";
    private static final String METHOD_STREAM = "stream";

    public String minimalJavaVersion() {
        return "1.8";
    }

    public boolean isDraft() {
        return false;
    }

    public String getId() {
        return "ArraysDotStream";
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/use-arrays-stream.html";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        Expression filterPredicate;
        boolean useStreamOf;
        if (!(node instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr methodCall = (MethodCallExpr)node;
        String methodCallIdentifier = methodCall.getNameAsString();
        if (!METHOD_STREAM.equals(methodCallIdentifier)) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (optScope.isEmpty()) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        if (!(scope instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr scopeAsMethodCallExpr = (MethodCallExpr)scope;
        if (!METHOD_ASLIST.equals(scopeAsMethodCallExpr.getName().getIdentifier())) {
            return false;
        }
        Optional optParentScope = scopeAsMethodCallExpr.getScope();
        if (optParentScope.isEmpty()) {
            return false;
        }
        Expression parentScope = (Expression)optParentScope.get();
        if (!parentScope.isNameExpr()) {
            return false;
        }
        if (!parentScope.asNameExpr().getNameAsString().equals(Arrays.class.getSimpleName())) {
            return false;
        }
        if (scopeAsMethodCallExpr.getArguments().size() != 1) {
            useStreamOf = true;
        } else {
            filterPredicate = scopeAsMethodCallExpr.getArgument(0);
            Optional<ResolvedType> optType = this.optResolvedType(filterPredicate);
            if (optType.isEmpty()) {
                return false;
            }
            boolean bl = useStreamOf = !optType.get().isArray();
        }
        if (useStreamOf) {
            Optional compilationUnit = node.findAncestor(new Class[]{CompilationUnit.class});
            String methodRefClassName = this.getStaticMethodClassRefMayAddImport(compilationUnit, Stream.class);
            NameExpr nameExpr = new NameExpr(methodRefClassName);
            return node.replace((Node)new MethodCallExpr((Expression)nameExpr, "of", scopeAsMethodCallExpr.getArguments()));
        }
        filterPredicate = scopeAsMethodCallExpr.getArgument(0);
        NodeList replaceArguments = new NodeList((Node[])new Expression[]{filterPredicate});
        MethodCallExpr replacement = new MethodCallExpr(parentScope, METHOD_STREAM, replaceArguments);
        LOGGER.info("Turning {} into {}", (Object)methodCall, (Object)replacement);
        return methodCall.replace((Node)replacement);
    }

    private String getStaticMethodClassRefMayAddImport(Optional<CompilationUnit> optCompilationUnit, Class<?> clazz) {
        String methodRefClassName;
        String qualifiedName = clazz.getName();
        if (optCompilationUnit.isEmpty()) {
            return qualifiedName;
        }
        String classSimpleName = clazz.getSimpleName();
        CompilationUnit compilationUnit = optCompilationUnit.get();
        if (this.isImported(compilationUnit, clazz.getPackageName(), qualifiedName)) {
            methodRefClassName = classSimpleName;
        } else if (this.isImportable(compilationUnit, qualifiedName)) {
            compilationUnit.addImport(qualifiedName, false, false);
            methodRefClassName = classSimpleName;
        } else {
            methodRefClassName = qualifiedName;
        }
        return methodRefClassName;
    }
}

