/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.Resolvable;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.google.common.annotations.VisibleForTesting;
import eu.solven.cleanthat.SuppressCleanthat;
import eu.solven.cleanthat.engine.java.refactorer.function.OnMethodName;
import eu.solven.cleanthat.engine.java.refactorer.meta.IJavaparserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.pepper.logging.PepperLogHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AJavaparserMutator
implements IJavaparserMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AJavaparserMutator.class);
    private static final AtomicInteger WARNS_IDEMPOTENCY_COUNT = new AtomicInteger();

    @Deprecated
    @VisibleForTesting
    public static int getWarnCount() {
        return WARNS_IDEMPOTENCY_COUNT.get();
    }

    protected boolean replaceBy(Node replacee, Node replacementNode) {
        LOGGER.info("Replacing `{}` by `{}`", (Object)replacee, (Object)replacementNode);
        return replacee.replace(replacementNode);
    }

    public Optional<Node> walkAst(Node tree) {
        AtomicBoolean transformed = new AtomicBoolean();
        tree.walk(node -> {
            boolean hasTransformed;
            Optional optSuppressedParent = node.findAncestor(n -> n.isAnnotationPresent(SuppressCleanthat.class), new Class[]{NodeWithAnnotations.class});
            Optional optSuppressedChildren = node.findFirst(Node.class, n -> n instanceof NodeWithAnnotations && ((NodeWithAnnotations)n).isAnnotationPresent(SuppressCleanthat.class));
            if (node instanceof NodeWithAnnotations && ((NodeWithAnnotations)node).isAnnotationPresent(SuppressCleanthat.class) || optSuppressedParent.isPresent() || optSuppressedChildren.isPresent()) {
                LOGGER.debug("We skip {} due to {}", node, (Object)SuppressCleanthat.class.getName());
                return;
            }
            try {
                LOGGER.trace("{} is going over {}", (Object)this.getClass().getSimpleName(), PepperLogHelper.getObjectAndClass((Object)node));
                hasTransformed = this.processNotRecursively((Node)node);
            }
            catch (RuntimeException e) {
                String rangeInSourceCode = "Around lines: " + node.getTokenRange().map(Object::toString).orElse("-");
                String messageForIssueReporting = AJavaparserMutator.messageForIssueReporting((IMutator)this, node);
                throw new IllegalArgumentException("Issue with a cleanthat mutator. " + rangeInSourceCode + " " + messageForIssueReporting, e);
            }
            if (hasTransformed) {
                LOGGER.debug("{} transformed something into `{}`", (Object)this, node);
                this.idempotencySanityCheck((Node)node);
                transformed.set(true);
            }
        });
        if (transformed.get()) {
            return Optional.of(tree);
        }
        return Optional.empty();
    }

    private void idempotencySanityCheck(Node node) {
        boolean transformAgain = this.processNotRecursively(node);
        if (!this.getIds().contains("NoOp") && transformAgain) {
            WARNS_IDEMPOTENCY_COUNT.incrementAndGet();
            String messageForIssueReporting = AJavaparserMutator.messageForIssueReporting((IMutator)this, node);
            LOGGER.warn("A mutator is not idem-potent. {}", (Object)messageForIssueReporting);
        }
    }

    public static String messageForIssueReporting(IMutator mutator, Node node) {
        String faultyCode = node.toString();
        String messageForIssueReporting = "\r\n\r\nPlease report it to 'https://github.com/solven-eu/cleanthat/issues' referring the faulty mutator: '" + mutator.getClass().getName() + " with as testCase: \r\n\r\n" + faultyCode;
        return messageForIssueReporting;
    }

    protected boolean processNotRecursively(Node node) {
        Optional<Node> optReplacement = this.replaceNode(node);
        if (optReplacement.isPresent()) {
            Node replacement = optReplacement.get();
            return this.tryReplace(node, replacement);
        }
        return false;
    }

    protected boolean tryReplace(Node node, Node replacement) {
        if (this.cancelDueToComment(node)) {
            LOGGER.info("We skip removing {} due to the presence of a comment", (Object)node);
            return false;
        }
        LOGGER.info("Turning `{}` into `{}`", (Object)node, (Object)replacement);
        boolean result = node.replace(replacement);
        if (!result) {
            LOGGER.warn("We failed turning `{}` into `{}`", (Object)node, (Object)replacement);
        }
        return result;
    }

    protected boolean tryRemove(Node node) {
        if (this.cancelDueToComment(node)) {
            LOGGER.info("We skip removing {} due to the presence of a comment", (Object)node);
            return false;
        }
        String nodeParentAsString = node.getParentNode().map(n -> n.getClass().getSimpleName()).orElse("-");
        LOGGER.info("Removing `{}` from a {}", (Object)node, (Object)nodeParentAsString);
        boolean result = node.remove();
        if (!result) {
            LOGGER.warn("Failed removing `{}` from a {}", (Object)node, (Object)nodeParentAsString);
        }
        return result;
    }

    protected boolean cancelDueToComment(Node node) {
        if (node.findFirst(Node.class, n -> n.getComment().isPresent()).isPresent()) {
            LOGGER.debug("You should cancel the operation due to the presence of a comment");
            return true;
        }
        return false;
    }

    protected Optional<Node> replaceNode(Node node) {
        throw new UnsupportedOperationException("TODO Implement me in overriden classes");
    }

    protected Optional<ResolvedType> optResolvedType(Expression expr) {
        if (expr.findCompilationUnit().isEmpty()) {
            return Optional.empty();
        }
        try {
            ResolvedType type = expr.calculateResolvedType();
            return Optional.of(type);
        }
        catch (RuntimeException e) {
            try {
                ResolvedType secondTryType = expr.calculateResolvedType();
                this.logJavaParserIssue(expr, e, "https://github.com/javaparser/javaparser/issues/3939");
                return Optional.of(secondTryType);
            }
            catch (RuntimeException ee) {
                LOGGER.debug("Issue resolving the type of {}", (Object)expr, (Object)ee);
                return Optional.empty();
            }
            catch (NoClassDefFoundError ee) {
                this.logJavaParserIssue(expr, e, "https://github.com/javaparser/javaparser/issues/3504");
                return Optional.empty();
            }
        }
        catch (NoClassDefFoundError e) {
            this.logJavaParserIssue(expr, e, "https://github.com/javaparser/javaparser/issues/3504");
            return Optional.empty();
        }
    }

    private void logJavaParserIssue(Object o, Throwable e, String issue) {
        String msg = "We encounter a case of {} for `{}`. Full-stack is available in 'debug'";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn(msg, new Object[]{issue, o, e});
        } else {
            LOGGER.warn(msg, (Object)issue, o);
        }
    }

    protected Optional<ResolvedType> optResolvedType(Type type) {
        try {
            return Optional.of(type.resolve());
        }
        catch (RuntimeException e) {
            try {
                ResolvedType secondTryType = type.resolve();
                this.logJavaParserIssue(type, e, "https://github.com/javaparser/javaparser/issues/3939");
                return Optional.of(secondTryType);
            }
            catch (RuntimeException ee) {
                LOGGER.debug("Issue with JavaParser over {}", (Object)type, (Object)ee);
                return Optional.empty();
            }
        }
        catch (NoClassDefFoundError e) {
            this.logJavaParserIssue(type, e, "https://github.com/javaparser/javaparser/issues/3504");
            return Optional.empty();
        }
    }

    protected Optional<ResolvedDeclaration> optResolved(Expression expr) {
        if (expr.findCompilationUnit().isEmpty()) {
            return Optional.empty();
        }
        if (!(expr instanceof Resolvable)) {
            return Optional.empty();
        }
        try {
            Object resolved = ((Resolvable)expr).resolve();
            return Optional.of((ResolvedDeclaration)resolved);
        }
        catch (UnsolvedSymbolException e) {
            LOGGER.debug("Typically a 3rd-party symbol (e.g. in some library not loaded by CleanThat)", (Throwable)e);
            return Optional.empty();
        }
        catch (IllegalStateException | UnsupportedOperationException e) {
            if (e.getMessage().contains(SymbolResolver.class.getSimpleName())) {
                LOGGER.debug("Typically a 3rd-party symbol (e.g. in some library not loaded by CleanThat)", (Throwable)e);
                return Optional.empty();
            }
            if (e.getMessage().contains("unsolved symbol")) {
                LOGGER.debug("Typically a 3rd-party symbol (e.g. in some library not loaded by CleanThat)", (Throwable)e);
                return Optional.empty();
            }
            throw new IllegalStateException(e);
        }
    }

    protected void onMethodName(Node node, String methodName, OnMethodName consumer) {
        if (node instanceof MethodCallExpr && methodName.equals(((MethodCallExpr)node).getName().getIdentifier())) {
            MethodCallExpr methodCall = (MethodCallExpr)node;
            Optional optScope = methodCall.getScope();
            if (optScope.isEmpty()) {
                return;
            }
            Expression scope = (Expression)optScope.get();
            Optional<ResolvedType> type = this.optResolvedType(scope);
            if (type.isPresent()) {
                consumer.onMethodName(methodCall, scope, type.get());
            }
        }
    }

    protected boolean scopeHasRequiredType(Optional<Expression> optScope, Class<?> requiredType) {
        return this.scopeHasRequiredType(optScope, requiredType.getName());
    }

    protected boolean scopeHasRequiredType(Optional<Expression> optScope, String requiredType) {
        Optional<ResolvedType> optType = optScope.flatMap(this::optResolvedType);
        return this.typeHasRequiredType(optType, requiredType);
    }

    protected boolean isAssignableBy(ReferenceTypeImpl referenceTypeImpl, ResolvedType resolvedType) {
        try {
            return referenceTypeImpl.isAssignableBy(resolvedType);
        }
        catch (UnsolvedSymbolException e) {
            LOGGER.debug("Unresolved: `{}` .isAssignableBy `{}`", new Object[]{referenceTypeImpl, resolvedType, e});
            return false;
        }
    }

    protected boolean isAssignableBy(String qualifiedClassName, ResolvedType resolvedType) {
        ReflectionTypeSolver typeSolver = new ReflectionTypeSolver(false);
        SymbolReference optType = typeSolver.tryToSolveType(qualifiedClassName);
        if (!optType.isSolved()) {
            return false;
        }
        ReferenceTypeImpl referenceTypeImpl = new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)optType.getCorrespondingDeclaration());
        return this.isAssignableBy(referenceTypeImpl, resolvedType);
    }

    protected boolean typeHasRequiredType(Optional<ResolvedType> optType, String requiredType) {
        if (optType.isEmpty()) {
            return false;
        }
        ResolvedType type = optType.get();
        boolean isCorrectClass = false;
        if (type.isConstraint()) {
            type = type.asConstraintType().getBound();
        }
        if (this.isAssignableBy(requiredType, type)) {
            isCorrectClass = true;
        } else if (type.isPrimitive() && type.asPrimitive().describe().equals(requiredType)) {
            isCorrectClass = true;
        } else if (type.isPrimitive() && type.asPrimitive().describe().equals(requiredType)) {
            isCorrectClass = true;
        }
        return isCorrectClass;
    }

    protected boolean isImported(CompilationUnit compilationUnit, String methodRefPackage, String qualifiedName) {
        String packageDecl;
        Optional optPackageDeclaration = compilationUnit.getPackageDeclaration();
        if (optPackageDeclaration.isPresent() && methodRefPackage.equals(packageDecl = ((PackageDeclaration)optPackageDeclaration.get()).getNameAsString())) {
            return true;
        }
        NodeList imports = compilationUnit.getImports();
        if (imports.isEmpty() && methodRefPackage.indexOf(46) >= 0) {
            return false;
        }
        if ("java.lang".equals(methodRefPackage)) {
            return true;
        }
        return imports.stream().anyMatch(id -> id.getNameAsString().equals(qualifiedName));
    }

    protected String nameOrQualifiedName(CompilationUnit compilationUnit, Class<?> clazz) {
        if (this.isImported(compilationUnit, clazz.getPackageName(), clazz.getName())) {
            return clazz.getSimpleName();
        }
        return clazz.getName();
    }

    protected boolean isImportable(CompilationUnit compilationUnit, String qualifiedName) {
        NodeList imports = compilationUnit.getImports();
        String tokenName = this.getSimpleName(qualifiedName);
        return imports.stream().noneMatch(id -> id.isAsterisk() || this.getSimpleName(id.getNameAsString()).equals(tokenName));
    }

    protected String getSimpleName(String qualifiedName) {
        int indexOfDot = qualifiedName.lastIndexOf(46);
        if (indexOfDot < 0) {
            return qualifiedName;
        }
        return qualifiedName.substring(indexOfDot + 1);
    }

    protected boolean isMethodReturnUsed(MethodCallExpr methodCall) {
        if (!methodCall.getParentNode().isPresent()) {
            return false;
        }
        Node parentNode = (Node)methodCall.getParentNode().get();
        return !(parentNode instanceof ExpressionStmt);
    }
}

