/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java;

import eu.solven.cleanthat.config.ConfigHelpers;
import eu.solven.cleanthat.config.pojo.CleanthatEngineProperties;
import eu.solven.cleanthat.config.pojo.CleanthatStepProperties;
import eu.solven.cleanthat.config.pojo.ICleanthatStepParametersProperties;
import eu.solven.cleanthat.engine.ASourceCodeFormatterFactory;
import eu.solven.cleanthat.engine.IEngineStep;
import eu.solven.cleanthat.engine.java.refactorer.JavaRefactorer;
import eu.solven.cleanthat.engine.java.refactorer.JavaRefactorerProperties;
import eu.solven.cleanthat.engine.java.refactorer.JavaRefactorerStep;
import eu.solven.cleanthat.formatter.CleanthatSession;
import eu.solven.cleanthat.formatter.ILintFixer;
import eu.solven.cleanthat.language.IEngineProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFormattersFactory
extends ASourceCodeFormatterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaFormattersFactory.class);

    public JavaFormattersFactory(ConfigHelpers configHelpers) {
        super(configHelpers);
    }

    public String getEngine() {
        return "javaparser";
    }

    public ILintFixer makeLintFixer(CleanthatSession cleanthatSession, IEngineProperties engineProperties, CleanthatStepProperties stepProperties) {
        JavaRefactorer processor;
        String stepId = stepProperties.getId();
        ICleanthatStepParametersProperties parameters = this.getParameters(stepProperties);
        LOGGER.debug("Processing: {}", (Object)stepId);
        switch (stepId) {
            case "refactorer": {
                JavaRefactorerProperties processorConfig = (JavaRefactorerProperties)this.convertValue(parameters, JavaRefactorerProperties.class);
                JavaRefactorer javaRefactorer = new JavaRefactorer(engineProperties, processorConfig);
                LOGGER.info("Mutators: {}", (Object)javaRefactorer.getMutators());
                processor = javaRefactorer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown step: " + stepId);
            }
        }
        if (!processor.getId().equals(stepId)) {
            throw new IllegalStateException("Inconsistency: " + processor.getId() + " vs " + stepId);
        }
        return processor;
    }

    public CleanthatEngineProperties makeDefaultProperties(Set<String> steps) {
        CleanthatEngineProperties.CleanthatEnginePropertiesBuilder engineBuilder = CleanthatEngineProperties.builder().engine(this.getEngine());
        if (steps.contains("refactorer")) {
            engineBuilder.step(CleanthatStepProperties.builder().id("refactorer").parameters((ICleanthatStepParametersProperties)JavaRefactorerProperties.defaults()).build());
        }
        return engineBuilder.build();
    }

    public Map<String, String> makeCustomDefaultFiles(CleanthatEngineProperties engineProperties, Set<String> subStepIds) {
        return Map.of();
    }

    public List<IEngineStep> getMainSteps() {
        return Arrays.asList(new JavaRefactorerStep());
    }
}

