/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.codeprovider.resource;

import eu.solven.cleanthat.codeprovider.ICodeProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class CleanthatUrlLoader {
    public static final String PREFIX_CLASSPATH_ECLIPSE = "classpath:/eclipse/";
    @Deprecated
    public static final String PREFIX_CODE_LEGACY = "code:";
    public static final String PREFIX_CODE = "repository:";

    protected CleanthatUrlLoader() {
    }

    public static Resource loadUrl(ICodeProvider codeProvider, String configFile) {
        Resource resource;
        if (configFile.startsWith(PREFIX_CODE)) {
            String path = configFile.substring(PREFIX_CODE.length());
            resource = CleanthatUrlLoader.loadFromRepository(codeProvider, path);
        } else if (configFile.startsWith(PREFIX_CODE_LEGACY)) {
            String path = configFile.substring(PREFIX_CODE_LEGACY.length());
            resource = CleanthatUrlLoader.loadFromRepository(codeProvider, path);
        } else if (configFile.startsWith(PREFIX_CLASSPATH_ECLIPSE)) {
            resource = new DefaultResourceLoader().getResource(configFile);
        } else {
            throw new IllegalArgumentException("You must prefix with 'repository:'. Was '" + configFile + "'");
        }
        return resource;
    }

    public static Resource loadFromRepository(ICodeProvider codeProvider, String path) {
        Optional<String> optContent;
        if (path.startsWith("/")) {
            path = path.substring("/".length());
        }
        try {
            optContent = codeProvider.loadContentForPath(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (optContent.isEmpty()) {
            throw new IllegalStateException("There is no content at: " + path + " (provider: " + codeProvider + ")");
        }
        return new ByteArrayResource(optContent.get().getBytes(StandardCharsets.UTF_8), path);
    }
}

