/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.code_provider.inmemory;

import com.google.common.jimfs.Jimfs;
import eu.solven.cleanthat.code_provider.CleanthatPathHelpers;
import eu.solven.cleanthat.codeprovider.CodeProviderHelpers;
import eu.solven.cleanthat.codeprovider.DummyCodeProviderFile;
import eu.solven.cleanthat.codeprovider.ICodeProviderFile;
import eu.solven.cleanthat.codeprovider.ICodeProviderWriter;
import eu.solven.cleanthat.codeprovider.ICodeWritingMetadata;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemCodeProvider
implements ICodeProviderWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemCodeProvider.class);
    final FileSystem fs;
    final Path root;

    public FileSystemCodeProvider(Path root) {
        this.fs = root.getFileSystem();
        this.root = root.normalize();
        if (!this.root.equals(root)) {
            throw new IllegalArgumentException("The root is illegal: " + root);
        }
    }

    public static FileSystemCodeProvider forTests() throws IOException {
        FileSystem fs = Jimfs.newFileSystem();
        return new FileSystemCodeProvider(CodeProviderHelpers.getRoot(fs));
    }

    @Override
    public Path getRepositoryRoot() {
        return this.root;
    }

    @Override
    public void listFilesForContent(Set<String> includes, Consumer<ICodeProviderFile> consumer) throws IOException {
        this.listFilesForContent((Path p) -> false, consumer);
    }

    protected void listFilesForContent(final Predicate<Path> ignorePredicate, final Consumer<ICodeProviderFile> consumer) throws IOException {
        Files.walkFileTree(this.root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (ignorePredicate.test(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (ignorePredicate.test(file)) {
                    return FileVisitResult.CONTINUE;
                }
                if (!file.startsWith(FileSystemCodeProvider.this.root)) {
                    throw new IllegalStateException("Issue given root=" + FileSystemCodeProvider.this.root + " and path=" + file);
                }
                Path relativized2 = FileSystemCodeProvider.this.root.relativize(file);
                String rawRelativized = CleanthatPathHelpers.makeContentRawPath((Path)FileSystemCodeProvider.this.root, (Path)relativized2);
                Path relativized = CleanthatPathHelpers.makeContentPath((Path)FileSystemCodeProvider.this.root, (String)rawRelativized);
                consumer.accept(new DummyCodeProviderFile(relativized, file));
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public String toString() {
        return this.root.toAbsolutePath().toString();
    }

    protected Path resolvePath(Path inMemoryPath) {
        return CleanthatPathHelpers.resolveChild((Path)this.root, (Path)inMemoryPath);
    }

    @Override
    public boolean persistChanges(Map<Path, String> pathToMutatedContent, ICodeWritingMetadata codeWritingMetadata) {
        Charset charset = StandardCharsets.UTF_8;
        AtomicBoolean hasWritten = new AtomicBoolean();
        pathToMutatedContent.forEach((inMemoryPath, content) -> {
            Path resolved = this.resolvePath((Path)inMemoryPath);
            try {
                String existingContent;
                Files.createDirectories(resolved.getParent(), new FileAttribute[0]);
                if (Files.exists(resolved, new LinkOption[0]) && (existingContent = Files.readString(resolved, charset)).equals(content)) {
                    LOGGER.info("We skip writing content as same content already present: {}", (Object)resolved);
                    return;
                }
                LOGGER.info("Write file: {}", (Object)resolved);
                Files.write(resolved, content.getBytes(charset), new OpenOption[0]);
                hasWritten.set(true);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Issue on: " + inMemoryPath + " (resolved into " + resolved + ")", e);
            }
        });
        return hasWritten.get();
    }

    @Override
    public Optional<String> loadContentForPath(Path path) throws IOException {
        CleanthatPathHelpers.checkContentPath((Path)path);
        Path pathForRootFS = CleanthatPathHelpers.resolveChild((Path)this.getRepositoryRoot(), (Path)path);
        if (Files.exists(pathForRootFS, new LinkOption[0])) {
            return Optional.of(Files.readString(pathForRootFS));
        }
        return Optional.empty();
    }

    @Override
    public String getRepoUri() {
        throw new IllegalArgumentException("No repository URI");
    }

    @Override
    public void cleanTmpFiles() {
        LOGGER.info("Nothing to delete for {}", (Object)this);
    }
}

