/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine;

import com.google.common.base.MoreObjects;
import eu.solven.cleanthat.formatter.ILintFixer;
import eu.solven.cleanthat.language.IEngineProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineAndLinters
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineAndLinters.class);
    final IEngineProperties engineProperties;
    final List<ILintFixer> linters;

    public EngineAndLinters(IEngineProperties engineProperties, List<ILintFixer> linters) {
        this.engineProperties = engineProperties;
        this.linters = linters;
    }

    public IEngineProperties getEngineProperties() {
        return this.engineProperties;
    }

    public List<ILintFixer> getLinters() {
        return this.linters;
    }

    public String toString() {
        MoreObjects.ToStringHelper builder = MoreObjects.toStringHelper((Object)this).add("engine", (Object)this.engineProperties.getEngine());
        for (int i = 0; i < this.linters.size(); ++i) {
            builder.add("step_" + i, (Object)this.linters.get(i));
        }
        return builder.toString();
    }

    @Override
    public void close() {
        this.linters.forEach(lf -> {
            if (lf instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)lf)).close();
                }
                catch (Exception e) {
                    LOGGER.warn("Issue closing {}", lf, (Object)e);
                }
            }
        });
    }
}

