/*
 * Decompiled with CFR 0.152.
 */
package org.mineskin;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import org.jsoup.Connection;
import org.mineskin.Model;
import org.mineskin.Variant;
import org.mineskin.Visibility;

public class SkinOptions {
    private static final String URL_FORMAT = "name=%s&model=%s&visibility=%s";
    private final String name;
    private final Variant variant;
    private final Visibility visibility;

    @Deprecated
    private SkinOptions(String name, Model model, Visibility visibility) {
        this.name = name;
        this.variant = model.toVariant();
        this.visibility = visibility;
    }

    private SkinOptions(String name, Variant variant, Visibility visibility) {
        this.name = name;
        this.variant = variant;
        this.visibility = visibility;
    }

    @Deprecated
    protected String toUrlParam() {
        return String.format(URL_FORMAT, this.name, this.variant.getName(), this.visibility.getCode());
    }

    protected JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (!Strings.isNullOrEmpty(this.name)) {
            json.addProperty("name", this.name);
        }
        if (this.variant != null && this.variant != Variant.AUTO) {
            json.addProperty("variant", this.variant.getName());
        }
        if (this.visibility != null) {
            json.addProperty("visibility", this.visibility.getCode());
        }
        return json;
    }

    protected void addAsData(Connection connection) {
        if (!Strings.isNullOrEmpty(this.name)) {
            connection.data("name", this.name);
        }
        if (this.variant != null && this.variant != Variant.AUTO) {
            connection.data("variant", this.variant.getName());
        }
        if (this.visibility != null) {
            connection.data("visibility", String.valueOf(this.visibility.getCode()));
        }
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public static SkinOptions create(String name, Model model, Visibility visibility) {
        return new SkinOptions(name, model, visibility);
    }

    public static SkinOptions create(String name, Variant variant, Visibility visibility) {
        return new SkinOptions(name, variant, visibility);
    }

    public static SkinOptions name(String name) {
        return new SkinOptions(name, Variant.AUTO, Visibility.PUBLIC);
    }

    public static SkinOptions none() {
        return new SkinOptions("", Variant.AUTO, Visibility.PUBLIC);
    }
}

