/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.parameters;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.exception.EmptyEntitySelectorException;
import revxrsal.commands.bukkit.exception.InvalidPlayerException;
import revxrsal.commands.bukkit.exception.MalformedEntitySelectorException;
import revxrsal.commands.bukkit.exception.MoreThanOneEntityException;
import revxrsal.commands.bukkit.exception.NonPlayerEntitiesException;
import revxrsal.commands.bukkit.util.BukkitVersion;
import revxrsal.commands.exception.CommandErrorException;
import revxrsal.commands.node.ExecutionContext;
import revxrsal.commands.parameter.ParameterType;
import revxrsal.commands.stream.MutableStringStream;
import revxrsal.commands.util.Collections;

public final class PlayerParameterType
implements ParameterType<BukkitCommandActor, Player> {
    @NotNull
    private static Player fromSelector(@NotNull CommandSender sender, @NotNull String selector) {
        try {
            List entityList = Bukkit.selectEntities((CommandSender)sender, (String)selector);
            if (entityList.isEmpty()) {
                throw new EmptyEntitySelectorException(selector);
            }
            if (entityList.size() != 1) {
                throw new MoreThanOneEntityException(selector);
            }
            Entity entity = (Entity)entityList.get(0);
            if (!(entity instanceof Player)) {
                throw new NonPlayerEntitiesException(selector);
            }
            Player player = (Player)entity;
            return player;
        }
        catch (IllegalArgumentException e) {
            throw new MalformedEntitySelectorException(selector, e.getCause().getMessage());
        }
        catch (NoSuchMethodError e) {
            throw new CommandErrorException("Entity selectors on legacy versions are not supported yet!", new Object[0]);
        }
    }

    public Player parse(@NotNull MutableStringStream input, @NotNull ExecutionContext<BukkitCommandActor> context) {
        String value = input.readString();
        if (BukkitVersion.isBrigadierSupported()) {
            return PlayerParameterType.fromSelector(((BukkitCommandActor)context.actor()).sender(), value);
        }
        if (value.equals("self") || value.equals("me") || value.equals("@s")) {
            return ((BukkitCommandActor)context.actor()).requirePlayer();
        }
        Player player = Bukkit.getPlayerExact((String)value);
        if (player != null) {
            return player;
        }
        throw new InvalidPlayerException(value);
    }

    @NotNull
    public SuggestionProvider<BukkitCommandActor> defaultSuggestions() {
        if (BukkitVersion.isBrigadierSupported()) {
            return SuggestionProvider.empty();
        }
        return (input, context) -> Collections.map((Iterable)Bukkit.getOnlinePlayers(), Player::getName);
    }
}

