/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.hooks;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.bukkit.actor.ActorFactory;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.FallbackPrefix;
import revxrsal.commands.bukkit.hooks.LampCommandExecutor;
import revxrsal.commands.bukkit.util.PluginCommands;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.hook.CancelHandle;
import revxrsal.commands.hook.CommandRegisteredHook;

public final class BukkitCommandHooks<A extends BukkitCommandActor>
implements CommandRegisteredHook<A> {
    private final Set<String> registeredRootNames = new HashSet<String>();
    private final JavaPlugin plugin;
    private final ActorFactory<A> actorFactory;
    private final String defaultFallbackPrefix;

    public BukkitCommandHooks(JavaPlugin plugin, ActorFactory<A> actorFactory, @NotNull String defaultFallbackPrefix) {
        this.plugin = plugin;
        this.actorFactory = actorFactory;
        this.defaultFallbackPrefix = defaultFallbackPrefix;
    }

    public void onRegistered(@NotNull ExecutableCommand<A> command, @NotNull CancelHandle cancelHandle) {
        String name = command.firstNode().name();
        if (this.registeredRootNames.add(name)) {
            String fallbackPrefix = (String)command.annotations().mapOr(FallbackPrefix.class, FallbackPrefix::value, (Object)this.defaultFallbackPrefix);
            PluginCommand cmd = PluginCommands.create(fallbackPrefix, command.firstNode().name(), this.plugin);
            LampCommandExecutor<A> executor = new LampCommandExecutor<A>(command.lamp(), this.actorFactory);
            cmd.setExecutor(executor);
            cmd.setTabCompleter(executor);
            if (cmd.getDescription().isEmpty() && command.description() != null) {
                cmd.setDescription(Objects.requireNonNull(command.description()));
            }
            if (cmd.getUsage().isEmpty()) {
                cmd.setUsage(command.usage());
            }
        }
    }
}

