/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.actor;

import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.Lamp;
import revxrsal.commands.bukkit.exception.SenderNotConsoleException;
import revxrsal.commands.bukkit.exception.SenderNotPlayerException;
import revxrsal.commands.command.CommandActor;

public interface BukkitCommandActor
extends CommandActor {
    @NotNull
    public CommandSender sender();

    default public boolean isPlayer() {
        return this.sender() instanceof Player;
    }

    default public boolean isConsole() {
        return this.sender() instanceof ConsoleCommandSender;
    }

    @Nullable
    default public Player asPlayer() {
        return this.isPlayer() ? (Player)this.sender() : null;
    }

    @NotNull
    default public Player requirePlayer() throws SenderNotPlayerException {
        if (!this.isPlayer()) {
            throw new SenderNotPlayerException();
        }
        return (Player)this.sender();
    }

    @NotNull
    default public ConsoleCommandSender requireConsole() throws SenderNotConsoleException {
        if (!this.isConsole()) {
            throw new SenderNotConsoleException();
        }
        return (ConsoleCommandSender)this.sender();
    }

    default public void sendRawMessage(@NotNull String message) {
        this.sender().sendMessage(message);
    }

    default public void sendRawError(@NotNull String message) {
        this.sender().sendMessage(ChatColor.RED + message);
    }

    public Lamp<BukkitCommandActor> lamp();

    @NotNull
    default public String name() {
        return this.sender().getName();
    }
}

