/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit;

import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.LampBuilderVisitor;
import revxrsal.commands.brigadier.types.ArgumentTypes;
import revxrsal.commands.bukkit.actor.ActorFactory;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.brigadier.BrigadierRegistryHook;
import revxrsal.commands.bukkit.brigadier.BukkitArgumentTypes;
import revxrsal.commands.bukkit.exception.BukkitExceptionHandler;
import revxrsal.commands.bukkit.hooks.BukkitCommandHooks;
import revxrsal.commands.bukkit.parameters.EntityParameterType;
import revxrsal.commands.bukkit.parameters.EntitySelectorParameterTypeFactory;
import revxrsal.commands.bukkit.parameters.OfflinePlayerParameterType;
import revxrsal.commands.bukkit.parameters.PlayerParameterType;
import revxrsal.commands.bukkit.parameters.WorldParameterType;
import revxrsal.commands.bukkit.sender.BukkitPermissionFactory;
import revxrsal.commands.bukkit.sender.BukkitSenderResolver;
import revxrsal.commands.bukkit.util.BukkitUtils;
import revxrsal.commands.bukkit.util.BukkitVersion;
import revxrsal.commands.command.CommandPermission;
import revxrsal.commands.exception.CommandExceptionHandler;
import revxrsal.commands.hook.CommandRegisteredHook;
import revxrsal.commands.parameter.ParameterType;
import revxrsal.commands.process.SenderResolver;

public final class BukkitVisitors {
    @NotNull
    public static <A extends BukkitCommandActor> LampBuilderVisitor<A> legacyColorCodes() {
        return builder -> builder.defaultMessageSender((actor, message) -> actor.sendRawMessage(BukkitUtils.legacyColorize(message))).defaultErrorSender((actor, message) -> actor.sendRawMessage(BukkitUtils.legacyColorize("&c" + message)));
    }

    @NotNull
    public static <A extends BukkitCommandActor> LampBuilderVisitor<A> bukkitExceptionHandler() {
        return builder -> builder.exceptionHandler((CommandExceptionHandler)new BukkitExceptionHandler());
    }

    @NotNull
    public static <A extends BukkitCommandActor> LampBuilderVisitor<A> bukkitSenderResolver() {
        return builder -> builder.senderResolver((SenderResolver)new BukkitSenderResolver());
    }

    @NotNull
    public static <A extends BukkitCommandActor> LampBuilderVisitor<A> bukkitParameterTypes() {
        return builder -> {
            builder.parameterTypes().addParameterTypeLast(Player.class, (ParameterType)new PlayerParameterType()).addParameterTypeLast(OfflinePlayer.class, (ParameterType)new OfflinePlayerParameterType()).addParameterTypeLast(World.class, (ParameterType)new WorldParameterType()).addParameterTypeFactoryLast((ParameterType.Factory)new EntitySelectorParameterTypeFactory());
            if (BukkitVersion.isBrigadierSupported()) {
                builder.parameterTypes().addParameterTypeLast(Entity.class, (ParameterType)new EntityParameterType());
            }
        };
    }

    @NotNull
    public static LampBuilderVisitor<BukkitCommandActor> registrationHooks(@NotNull JavaPlugin plugin) {
        return BukkitVisitors.registrationHooks(plugin, ActorFactory.defaultFactory());
    }

    @NotNull
    public static <A extends BukkitCommandActor> LampBuilderVisitor<A> registrationHooks(@NotNull JavaPlugin plugin, @NotNull ActorFactory<A> actorFactory) {
        return BukkitVisitors.registrationHooks(plugin, actorFactory, plugin.getName());
    }

    @NotNull
    public static <A extends BukkitCommandActor> LampBuilderVisitor<A> registrationHooks(@NotNull JavaPlugin plugin, @NotNull ActorFactory<A> actorFactory, @NotNull String defaultFallbackPrefix) {
        BukkitCommandHooks hooks = new BukkitCommandHooks(plugin, actorFactory, defaultFallbackPrefix);
        return builder -> builder.hooks().onCommandRegistered((CommandRegisteredHook)hooks);
    }

    @NotNull
    public static <A extends BukkitCommandActor> LampBuilderVisitor<A> pluginContextParameters(JavaPlugin plugin) {
        return builder -> {
            builder.parameterTypes().addContextParameterLast(Plugin.class, (parameter, context) -> plugin);
            builder.parameterTypes().addContextParameterLast(plugin.getClass(), (parameter, context) -> plugin);
            builder.dependency(Plugin.class, (Object)plugin);
            builder.dependency(plugin.getClass(), (Object)plugin);
        };
    }

    @NotNull
    public static <A extends BukkitCommandActor> LampBuilderVisitor<A> bukkitPermissions() {
        return builder -> builder.permissionFactory((CommandPermission.Factory)BukkitPermissionFactory.INSTANCE);
    }

    @NotNull
    public static LampBuilderVisitor<BukkitCommandActor> brigadier(@NotNull JavaPlugin plugin) {
        ArgumentTypes.Builder builder = BukkitArgumentTypes.builder();
        return BukkitVisitors.brigadier(plugin, builder.build(), ActorFactory.defaultFactory());
    }

    @NotNull
    public static LampBuilderVisitor<BukkitCommandActor> brigadier(@NotNull JavaPlugin plugin, @NotNull ArgumentTypes<? super BukkitCommandActor> argumentTypes) {
        return BukkitVisitors.brigadier(plugin, argumentTypes, ActorFactory.defaultFactory());
    }

    @NotNull
    public static <A extends BukkitCommandActor> LampBuilderVisitor<A> brigadier(@NotNull JavaPlugin plugin, @NotNull ArgumentTypes<? super A> argumentTypes, @NotNull ActorFactory<A> actorFactory) {
        if (BukkitVersion.isBrigadierSupported()) {
            return builder -> builder.hooks().onCommandRegistered(new BrigadierRegistryHook(argumentTypes, actorFactory, plugin));
        }
        return LampBuilderVisitor.nothing();
    }
}

