/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.versionmatched;

import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

final class VersionClass<T> {
    private static final char[] NUMBERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    @NotNull
    private final String rawClassName;
    @NotNull
    private final Class<? extends T> clazz;

    private VersionClass(@NotNull String rawClassName, @NotNull Class<? extends T> clazz) {
        this.rawClassName = rawClassName;
        this.clazz = clazz;
    }

    VersionClass(@NotNull Class<? extends T> clazz) {
        this(clazz.getSimpleName(), clazz);
    }

    @NotNull
    Class<? extends T> getVersionClass() {
        return this.clazz;
    }

    boolean match(@NotNull String version) {
        return this.version().equals(version);
    }

    @NotNull
    private String version() {
        int sub = this.versionSubString();
        if (sub == -1) {
            throw new IllegalStateException("version() -> Invalid name for \"" + this.clazz.getSimpleName() + '\"');
        }
        return this.rawClassName.substring(sub);
    }

    private int versionSubString() {
        AtomicInteger subString = new AtomicInteger();
        block0: for (char name : this.rawClassName.toCharArray()) {
            for (char number : NUMBERS) {
                if (name == number) break block0;
            }
            subString.incrementAndGet();
        }
        return subString.get();
    }
}

