/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.reflection.field;

import io.github.portlek.reflection.RefField;
import io.github.portlek.reflection.RefFieldExecuted;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldOf
implements RefField {
    @NotNull
    private final Field field;

    @Override
    @NotNull
    public Class<?> type() {
        return this.field.getType();
    }

    @Override
    @NotNull
    public String name() {
        return this.field.getName();
    }

    @Override
    @NotNull
    public RefFieldExecuted of(@Nullable Object object) {
        return new FieldExecuted(this.field, object);
    }

    @Override
    public <A extends Annotation> Optional<A> annotation(@NotNull Class<A> annotationClass) {
        return Optional.ofNullable(this.field.getDeclaredAnnotation(annotationClass));
    }

    public FieldOf(@NotNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        this.field = field;
    }

    private static final class FieldExecuted
    implements RefFieldExecuted {
        @NotNull
        private final Field field;
        @Nullable
        private final Object object;

        @Override
        public void set(@NotNull Object value) {
            boolean accessible = this.field.isAccessible();
            this.field.setAccessible(true);
            this.field.set(this.object, value);
            this.field.setAccessible(accessible);
        }

        @Override
        @NotNull
        public Optional<Object> get() {
            boolean accessible = this.field.isAccessible();
            this.field.setAccessible(true);
            try {
                Optional<Object> optional = Optional.ofNullable(this.field.get(this.object));
                this.field.setAccessible(accessible);
                return optional;
            }
            catch (Throwable throwable) {
                this.field.setAccessible(accessible);
                throw throwable;
            }
        }

        public FieldExecuted(@NotNull Field field, @Nullable Object object) {
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.field = field;
            this.object = object;
        }
    }
}

