/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.versionmatched;

import io.github.portlek.bukkitversion.BukkitVersion;
import io.github.portlek.reflection.RefConstructed;
import io.github.portlek.reflection.clazz.ClassOf;
import io.github.portlek.versionmatched.VersionClass;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class VersionMatched<T> {
    @NotNull
    private final String rawVersion;
    @NotNull
    private final List<VersionClass<T>> versionClasses;

    public VersionMatched(@NotNull String rawVersion, @NotNull List<VersionClass<T>> versionClasses) {
        this.rawVersion = rawVersion;
        this.versionClasses = versionClasses;
    }

    public VersionMatched(@NotNull BukkitVersion version, @NotNull List<VersionClass<T>> versionClasses) {
        this(version.getVersion(), versionClasses);
    }

    @SafeVarargs
    public VersionMatched(@NotNull String rawVersion, Class<? extends T> ... versionClasses) {
        this(rawVersion, Arrays.stream(versionClasses).map(VersionClass::new).collect(Collectors.toList()));
    }

    @SafeVarargs
    public VersionMatched(Class<? extends T> ... versionClasses) {
        this(new BukkitVersion(), Arrays.stream(versionClasses).map(VersionClass::new).collect(Collectors.toList()));
    }

    @NotNull
    public RefConstructed<T> of(Object ... types) {
        Class match = this.match();
        return new ClassOf<T>(match).constructor(types).orElseThrow(() -> new IllegalStateException("match() -> Couldn't find any constructor on \"" + match.getSimpleName() + '\"' + " version!"));
    }

    @NotNull
    public RefConstructed<T> ofPrimitive(Object ... types) {
        Class match = this.match();
        return new ClassOf<T>(match).primitiveConstructor(types).orElseThrow(() -> new IllegalStateException("match() -> Couldn't find any constructor on \"" + match.getSimpleName() + '\"' + " version!"));
    }

    @NotNull
    private Class<? extends T> match() {
        return this.versionClasses.stream().filter(versionClass -> versionClass.match(this.rawVersion)).map(VersionClass::getVersionClass).findFirst().orElseThrow(() -> new IllegalStateException("match() -> Couldn't find any matched class on \"" + this.rawVersion + '\"' + " version!"));
    }
}

