/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.mapentry;

import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class MapEntry<K, V>
implements Map.Entry<K, V> {
    @NotNull
    private final K key;
    @NotNull
    private final V value;

    @NotNull
    public static <K, V> Map.Entry<K, V> from(@NotNull K key, @NotNull V value) {
        return new MapEntry<K, V>(key, value);
    }

    @Override
    public V setValue(@NotNull V yvalue) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is an immutable class, you can't edit it!");
    }

    @Override
    public int hashCode() {
        return this.key.hashCode() ^ this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Map.Entry && ((Map.Entry)obj).getKey().equals(this.key) && ((Map.Entry)obj).getValue().equals(this.value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    public MapEntry(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.key = key;
        this.value = value;
    }

    @Override
    @NotNull
    public K getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public V getValue() {
        return this.value;
    }
}

