/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.reflection.method;

import io.github.portlek.reflection.RefMethod;
import io.github.portlek.reflection.RefMethodExecuted;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodOf
implements RefMethod {
    @NotNull
    private final Method method;

    public MethodOf(@NotNull Method method) {
        this.method = method;
    }

    @Override
    @NotNull
    public RefMethodExecuted of(@Nullable Object object) {
        return new MethodExecuted(object);
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(@NotNull Class<A> annotationClass) {
        return Optional.ofNullable(this.method.getDeclaredAnnotation(annotationClass));
    }

    private final class MethodExecuted
    implements RefMethodExecuted {
        @Nullable
        private final Object object;

        MethodExecuted(Object object) {
            this.object = object;
        }

        @Override
        @NotNull
        public Optional<Object> call(Object ... parameters) {
            boolean accessible = MethodOf.this.method.isAccessible();
            try {
                MethodOf.this.method.setAccessible(true);
                Optional<Object> optional = Optional.ofNullable(MethodOf.this.method.invoke(this.object, parameters));
                return optional;
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                throw new IllegalStateException(exception);
            }
            finally {
                MethodOf.this.method.setAccessible(accessible);
            }
        }
    }
}

