/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.reflection.field;

import io.github.portlek.reflection.RefField;
import io.github.portlek.reflection.RefFieldExecuted;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldOf
implements RefField {
    @NotNull
    private final Field field;

    public FieldOf(@NotNull Field field) {
        this.field = field;
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    @NotNull
    public String getName() {
        return this.field.getName();
    }

    @Override
    @NotNull
    public RefFieldExecuted of(@Nullable Object object) {
        return new FieldExecuted(object);
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(@NotNull Class<A> annotationClass) {
        return Optional.ofNullable(this.field.getDeclaredAnnotation(annotationClass));
    }

    private final class FieldExecuted
    implements RefFieldExecuted {
        @Nullable
        private final Object object;

        FieldExecuted(Object object) {
            this.object = object;
        }

        @Override
        @NotNull
        public Optional<Object> getValue() {
            boolean accessible = FieldOf.this.field.isAccessible();
            try {
                FieldOf.this.field.setAccessible(true);
                Optional<Object> optional = Optional.ofNullable(FieldOf.this.field.get(this.object));
                return optional;
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException(exception);
            }
            finally {
                FieldOf.this.field.setAccessible(accessible);
            }
        }

        @Override
        public void setValue(@NotNull Object value) {
            boolean accessible = FieldOf.this.field.isAccessible();
            try {
                FieldOf.this.field.setAccessible(true);
                FieldOf.this.field.set(this.object, value);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException(exception);
            }
            finally {
                FieldOf.this.field.setAccessible(accessible);
            }
        }
    }
}

