/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.equilibrium;

import io.github.portlek.equilibrium.Utilities;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;

public enum Equilibrium {
    EQUALS(Utilities::equals, "Utilities.equals(%s, %s)", "=", "=="),
    NOT_EQUALS(Utilities::notEqual, "Utilities.notEqual(%s, %s)", "!="),
    BIGGER(Utilities::isBigger, "Utilities.isBigger(%s, %s)", ">"),
    BIGGER_AND_EQUALS(Utilities::isBiggerEquals, "Utilities.isBiggerEquals(%s, %s)", "=>", ">="),
    LESS(Utilities::isLess, "Utilities.isLess(%s, %s)", "<"),
    LESS_OR_EQUALS(Utilities::isLessEquals, "Utilities.isLessEquals(%s, %s)", "<=", "=<"),
    INSTANCE_OF(Utilities::instanceOf, "Utilities.instanceOf(%s, %s)", "is", "instance of"),
    NOT_INSTANCE_OF(Utilities::noInstanceOf, "Utilities.noInstanceOf(%s, %s)", "isnt", "isn't", "isnot", "is not", "not instance of"),
    NOTHING((leftObject, rightObject) -> false, "", new String[0]);

    @NotNull
    private final List<String> operators;
    @NotNull
    private final BiPredicate<Object, Object> predicate;
    @NotNull
    private final String toString;

    private Equilibrium(@NotNull BiPredicate<Object, Object> predicate, String toString, String ... operators) {
        this(Arrays.asList(operators), predicate, toString);
    }

    @NotNull
    public static Equilibrium fromString(@NotNull String operator) {
        return Arrays.stream(Equilibrium.values()).filter(equilibrium -> equilibrium.getOperators().contains(operator)).findFirst().orElse(NOTHING);
    }

    public boolean control(@NotNull Object leftObject, @NotNull Object rightObject) {
        return this.predicate.test(leftObject, rightObject);
    }

    @NotNull
    public String toString() {
        return this.toString;
    }

    private Equilibrium(@NotNull List<String> operators, BiPredicate<Object, Object> predicate, String toString) {
        if (operators == null) {
            throw new NullPointerException("operators is marked non-null but is null");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        if (toString == null) {
            throw new NullPointerException("toString is marked non-null but is null");
        }
        this.operators = operators;
        this.predicate = predicate;
        this.toString = toString;
    }

    @NotNull
    public List<String> getOperators() {
        return this.operators;
    }
}

